% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{class}
\name{methylDiffDB-class}
\alias{methylDiffDB-class}
\alias{methylDiffDB}
\title{An S4 class that holds differential methylation information as flat file database}
\description{
This class is designed to hold statistics and locations for differentially 
methylated regions/bases as flat file database.
\code{\link{calculateDiffMeth}} function returns an object 
with \code{methylDiffDB} class.
}
\section{Slots}{
\describe{
   \item{\code{dbpath}:}{path to flat file database(s) }
   \item{\code{num.records}:}{number of records (lines) in the object}
   \item{\code{sample.ids}}{ids/names of samples in a vector}
   \item{\code{assembly}}{a name of genome assembly, such as :hg18,mm9, etc}
   \item{\code{context}}{numeric vector identifying which samples are which
   group }
   \item{\code{treatment}}{numeric vector identifying which samples are which
    group }
   \item{\code{destranded}}{logical denoting if methylation inormation is
    destranded or not}
   \item{\code{resolution}}{string either 'base' or 'region' defining the 
   resolution of methylation information}
   \item{\code{dbtype}:}{string for type of the flat file database, ex: tabix}

}
}

\section{Details}{

\code{methylDiffDB} class has the same functionality as 
\code{\link{methylDiff}} class, 
but the data is saved in a flat database file and therefore 
allocates less space in memory.
}

\section{Subsetting}{

 In the following code snippets, \code{x} is a \code{methylDiffDB}.
 Subsetting by \code{x[i,]} will produce a new object if subsetting is done 
 on rows. Column subsetting is not directly allowed to prevent errors in the 
 downstream analysis. see ?methylKit[ .
}

\section{Coercion}{

  \code{methylDiffDB} object can be coerced to:
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object via \code{\link{as}} function.
  \code{\link{methylDiff}} object via \code{\link{as}} function.
}

\section{Accessors}{
 
The following functions provides access to data slots of methylDiffDB:
- \code{\link{getData}}: get the data slot from the methylKit objects,
- \code{\link{getAssembly}}: get assembly of the genome,
- \code{\link{getContext}}: get the context of methylation
}

\examples{
data(methylKit)

methylDiffDB.obj <- calculateDiffMeth(methylBase.obj,save.db=TRUE,dbdir="methylDB")

library(GenomicRanges)
my.gr=as(methylDiffDB.obj,"GRanges")

# remove Database again
rm(methylDiffDB.obj)
unlink("methylDB",recursive=TRUE)

}
