% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utils}
\alias{utils}
\alias{.import_datasets}
\alias{.update_tse}
\alias{.print_message}
\alias{.set_optarg}
\alias{.check_formula}
\alias{.importBIOM}
\alias{.rownames2taxa}
\title{miaDash utilities}
\usage{
.import_datasets(selection)

.update_tse(tse, fun, fun.args = list())

.print_message(..., title = "Invalid input:")

.set_optarg(item, loader = NULL, alternative = NULL, ...)

.check_formula(form, tse)

.importBIOM(file, col.data = NULL, tree.file = NULL, ...)

.rownames2taxa(x)
}
\arguments{
\item{selection}{\code{Numeric vector}. A list of indices for the mia
datasets to return.}

\item{tse}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object.}

\item{fun}{\code{Function scalar}. Function to apply to \code{tse}.}

\item{fun.args}{\code{Named list}. A list of arguments to pass to \code{fun}.}

\item{...}{Either a series of strings to form the message returned by
\code{.print_message} or named arguments for \code{loader}.}

\item{title}{\code{Character scalar}. The title of the error message to
print. (Default: \code{"Invalid input:"})}

\item{item}{\code{Character scalar}. The file path from which the object
should be loaded.}

\item{loader}{\code{Function scalar}. The function to load \code{item}.
(Default: \code{NULL})}

\item{alternative}{an alternative output to return when at least one
\code{item} and \code{loader} are not defined. (Default: \code{NULL})}

\item{form}{\code{Character scalar} The formula to be checked.}
}
\value{
\itemize{
\item \code{.import_datasets}: returns the list of available mia datasets.
\item \code{.update_tse}: returns a TreeSE object after applying \code{fun}
with arguments \code{fun.args}. Eventual messages and errors are also
printed.
\item \code{.print_message}: returns a modalDialog with the error message
specified with \code{...} and titled \code{title}.
\item \code{.set_optarg}: returns an optional element for a TreeSE
constructor. The output is either an object located at the file path
\code{item} and loaded with \code{loader} or \code{alternative}.
\item \code{.check_formula}: returns \code{TRUE} or \code{FALSE} depending
whether or not all variables included in \code{form} are present in
\code{se} colData.
}
}
\description{
Helper functions to support the app functionality.
}
\keyword{internal}
