% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addLDA.R
\name{getLDA}
\alias{getLDA}
\alias{addLDA}
\alias{getLDA,SummarizedExperiment-method}
\alias{addLDA,SummarizedExperiment-method}
\title{Latent Dirichlet Allocation}
\usage{
getLDA(x, ...)

addLDA(x, ...)

\S4method{getLDA}{SummarizedExperiment}(x, k = 2, assay.type = "counts", eval.metric = "perplexity", ...)

\S4method{addLDA}{SummarizedExperiment}(x, k = 2, assay.type = "counts", name = "LDA", ...)
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object.}

\item{...}{optional arguments passed to \code{\link[topicmodels:LDA]{LDA}}}

\item{k}{\code{Integer vector}. A number of latent vectors/topics.
(Default: \code{2})}

\item{assay.type}{\code{Character scalar}. Specifies which assay to use for
LDA ordination. (Default: \code{"counts"})}

\item{eval.metric}{\code{Character scalar}. Specifies evaluation metric that
will be used to select the model with the best fit. Must be either
\code{"perplexity"} (\code{topicmodels::perplexity}) or \code{"coherence"}
(\code{topicdoc::topic_coherence}, the best model is selected based on mean
coherence). (Default: \code{"perplexity"})}

\item{name}{\code{Character scalar}. The name to be used to store the result
in the reducedDims of the output. (Default: \code{"LDA"})}
}
\value{
For \code{getLDA}, the ordination matrix with feature loadings matrix
as attribute \code{"loadings"}.

For \code{addLDA}, a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object is returned containing the ordination matrix in
\code{reducedDim(..., name)} with feature loadings matrix as attribute
\code{"loadings"}.
}
\description{
These functions perform Latent Dirichlet Allocation on data stored in a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object.
}
\details{
The functions \code{getLDA} and \code{addLDA} internally use
\code{\link[topicmodels:LDA]{LDA}} to compute the ordination matrix and
feature loadings.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns

# Reduce the number of features
tse <- agglomerateByPrevalence(tse, rank="Phylum")

# Run LDA and add the result to reducedDim(tse, "LDA")
tse <- addLDA(tse)

# Extract feature loadings
loadings <- getReducedDimAttribute(tse, "LDA", "loadings")
head(loadings)

# Estimate models with number of topics from 2 to 10
tse <- addLDA(tse, k = c(2, 3, 4, 5, 6, 7, 8, 9, 10), name = "LDA_10")
# Get the evaluation metrics
tab <- getReducedDimAttribute(tse, "LDA_10","eval_metrics")
# Plot
plot(tab[["k"]], tab[["perplexity"]], xlab = "k", ylab = "perplexity")
}
