% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runDPCoA.R
\name{getDPCoA}
\alias{getDPCoA}
\alias{runDPCoA}
\alias{getDPCoA,ANY,ANY-method}
\alias{getDPCoA,TreeSummarizedExperiment,missing-method}
\alias{calculateDPCoA}
\alias{addDPCoA}
\title{Calculation of Double Principal Correspondance analysis}
\usage{
getDPCoA(x, y, ...)

\S4method{getDPCoA}{ANY,ANY}(
  x,
  y,
  ncomponents = 2,
  ntop = NULL,
  subset.row = subset_row,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  ...
)

\S4method{getDPCoA}{TreeSummarizedExperiment,missing}(
  x,
  ...,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  tree.name = tree_name,
  tree_name = "phylo"
)

calculateDPCoA(x, ...)

addDPCoA(x, ..., altexp = NULL, name = "DPCoA")

runDPCoA(x, ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{y}{a \code{dist} or a symmetric \code{matrix} compatible with
\code{ade4:dpcoa}}

\item{...}{Currently not used.}

\item{ncomponents}{\code{Numeric scalar}. Indicates the number of DPCoA
dimensions to obtain. (Default: \code{2})}

\item{ntop}{\code{Numeric scalar}. Specifies the number of features with the
highest variances to use for dimensionality reduction. Alternatively
\code{NULL}, if all features should be used. (Default: \code{NULL})}

\item{subset.row}{\code{Character Vector}. Specifies the subset of features
to use for dimensionality reduction. This can be a character vector of row
names, an integer vector of row indices or a logical vector.
(Default: \code{NULL})}

\item{subset_row}{Deprecated. Use \code{subset.row} instead.}

\item{scale}{\code{Logical scalar}. Should the expression values be
standardized? (Default: \code{FALSE})}

\item{transposed}{\code{Logical scalar}. Specifies if x is transposed with
cells in rows. (Default: \code{FALSE})}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{exprs_values}{Deprecated. Use \code{assay.type} instead.}

\item{tree.name}{\code{Character scalar}. Specifies the name of the
tree to be included in the phyloseq object that is created,
(Default: \code{"phylo"})}

\item{tree_name}{Deprecated. Use \code{tree.name} instead.}

\item{altexp}{\code{Character scalar} or \code{integer scalar}. Specifies an
alternative experiment containing the input data. (Default: \code{NULL})}

\item{name}{\code{Character scalar}. A name for the column of the
\code{colData} where results will be stored. (Default: \code{"DPCoA"})}
}
\value{
For \code{getDPCoA} a matrix with samples as rows and CCA dimensions as
columns

For \code{addDPCoA} a modified \code{x} with the results stored in
\code{reducedDim} as the given \code{name}
}
\description{
Double Principal Correspondance analysis is made available via the
\code{ade4} package in typical fashion. Results are stored in the
\code{reducedDims} and are available for all the expected functions.
}
\details{
For \code{addDPCoA} a
\code{\link[TreeSummarizedExperiment]{TreeSummarizedExperiment}} containing
the expression values as well as a \code{rowTree} to calculate \code{y} using
\code{\link[ape:cophenetic.phylo]{cophenetic.phylo}}.

In addition to the reduced dimension on the features, the reduced dimension
for samples are returned as well as \code{sample_red} attribute.
\code{eig}, \code{feature_weights} and \code{sample_weights} are
returned as attributes as well.
}
\examples{
data(esophagus)
dpcoa <- getDPCoA(esophagus)
head(dpcoa)

esophagus <- addDPCoA(esophagus)
reducedDims(esophagus)

library(scater)
plotReducedDim(esophagus, "DPCoA")
}
\seealso{
\code{\link[scater:plotReducedDim]{plotReducedDim}}
\code{\link[SingleCellExperiment:reducedDims]{reducedDims}}
}
