% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_modulo_skewness.R
\name{log_modulo_skewness}
\alias{log_modulo_skewness}
\title{Log-Modulo Skewness Rarity Index}
\usage{
log_modulo_skewness(x, q = 0.5, n = 50)
}
\arguments{
\item{x}{Abundance matrix (taxa x samples) with counts}

\item{q}{Arithmetic abundance classes are evenly cut up to to this quantile
of the data. The assumption is that abundances higher than this are not
common, and they are classified in their own group.}

\item{n}{The number of arithmetic abundance classes from zero to the
quantile cutoff indicated by q.}
}
\value{
A vector of rarity indices
}
\description{
Calculates the community rarity index by log-modulo skewness.
}
\details{
The rarity index characterizes the concentration of species at low
abundance. Here, we use the skewness of the frequency distribution of
arithmetic abundance classes (see Magurran & McGill 2011).
These are typically right-skewed; to avoid taking log of occasional
negative skews, we follow Locey & Lennon (2016) and use the log-modulo
transformation that adds a value of one to each measure of skewness to
allow logarithmization.
}
\examples{
data(dietswap)
d <- log_modulo_skewness(dietswap)
}
\references{
Kenneth J. Locey and Jay T. Lennon.
Scaling laws predict global microbial diversity.
PNAS 2016 113 (21) 5970-5975; doi:10.1073/pnas.1521291113.

Magurran AE, McGill BJ, eds (2011)
Biological Diversity: Frontiers in Measurement and Assessment
(Oxford Univ Press, Oxford), Vol 12
}
\seealso{
core_abundance, low_abundance, alpha
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
