% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{analyzeAssociations}
\alias{analyzeAssociations}
\title{Association analysis}
\usage{
analyzeAssociations(
  object,
  variables,
  placeholder = "term",
  correction = "bonferroni",
  n_correction = NULL,
  exponentiate = FALSE
)
}
\arguments{
\item{object}{An existing fit from a model function such as lm, glm and many
others.}

\item{variables}{Character vector specifying variables to use in association
tests.}

\item{placeholder}{String specifying term in \code{object}'s formula which
should be substituted with variables during analysis.}

\item{correction}{String specifying multiple testing correction method. See
details for further information.}

\item{n_correction}{Integer specifying number of comparisons to consider
during multiple testing correction calculations. For Bonferroni correction
it is possible to specify a number lower than the number of comparisons
being made. This is useful in cases when knowledge about the biology or
redundance of alleles reduces the need for correction. For other methods it
must be at least equal to the number of comparisons being made; only set
this (to non-default) when you know what you are doing!}

\item{exponentiate}{Logical flag indicating whether or not to exponentiate
the coefficient estimates. Internally this is passed to
\code{\link[broom]{tidy}}. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults to
FALSE.}
}
\value{
Tibble containing combined results for all \code{variables}. The 
  first column \code{"term"} hold the names of \code{variables}. Further
  columns depends on the used model and are determined by associated 
  \code{tidy} function. Generally they will include \code{"estimate"}, 
  \code{"std.error"}, \code{"statistic"}, \code{"p.value"}, \code{"conf.low"},
  \code{"conf.high"}, \code{"p.adjusted"}.
}
\description{
\code{analyzeAssociations} perform association analysis on a single variable
level using a statistical model of choice.
}
\details{
\code{correction} specifies p-value adjustment method to use, common choice
is Benjamini & Hochberg (1995) (\code{"BH"}). Internally this is passed to
\link[stats]{p.adjust}.
}
\examples{
midas <- prepareMiDAS(hla_calls = MiDAS_tut_HLA,
                      colData = MiDAS_tut_pheno,
                      experiment = "hla_alleles")

# analyzeAssociations expects model data to be a data.frame
midas_data <- as.data.frame(midas)

# define base model
object <- lm(disease ~ term, data = midas_data)

# test for alleles associations
analyzeAssociations(object = object,
                    variables = c("B*14:02", "DRB1*11:01"))

}
