% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{distGrantham}
\alias{distGrantham}
\title{Calculate Grantham distance between amino acid sequences}
\usage{
distGrantham(aa1, aa2)
}
\arguments{
\item{aa1}{Character vector giving amino acid sequence using one letter
codings. Each element must correspond to single amino acid.}

\item{aa2}{Character vector giving amino acid sequence using one letter
codings. Each element must correspond to single amino acid.}
}
\value{
Numeric vector of normalized Grantham distance between \code{aa1} and
  \code{aa2}.
}
\description{
\code{distGrantham} calculates normalized Grantham distance between two
amino acid sequences. For details on calculations see
\href{http://www.sciencemag.org/content/185/4154/862.long}{Grantham R. 1974.}.
}
\details{
Distance between amino acid sequences is normalized by length of compared
sequences.

Lengths of \code{aa1} and \code{aa2} must be equal.
}
