% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getVariableAAPos}
\alias{getVariableAAPos}
\title{Find variable positions in sequence alignment}
\usage{
getVariableAAPos(alignment, varchar = "[A-Z]")
}
\arguments{
\item{alignment}{Matrix containing amino acid level alignment, as returned by
\code{\link{readHlaAlignments}},}

\item{varchar}{Regex matching characters that should be considered when
looking for variable amino acid positions. See details for further
explanations.}
}
\value{
Integer vector specifying which alignment columns are variable.
}
\description{
\code{getVariableAAPos} finds variable amino acid positions in protein
sequence alignment.
}
\details{
The variable amino acid positions in the alignment are those at which
different amino acids can be found. As the alignments can also contain indels
and unknown characters, the user choice might be to consider those positions
as variable or not. This can be achieved by passing appropriate regular
expression in \code{varchar}. Eg. when \code{varchar = "[A-Z]"} occurence of
deletion/insertion (".") will not be treated as variability. In order to
detect this kind of variability \code{varchar = "[A-Z\\\\.]"} should be used.
}
\examples{
alignment <- readHlaAlignments(gene = "TAP1")
getVariableAAPos(alignment)

}
