% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{hlaToVariable}
\alias{hlaToVariable}
\title{Convert HLA calls to variables}
\usage{
hlaToVariable(
  hla_calls,
  dictionary,
  reduce = TRUE,
  na.value = 0,
  nacols.rm = TRUE
)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{dictionary}{Path to file containing HLA allele dictionary or a
data frame.}

\item{reduce}{Logical indicating if function should try to reduce allele
resolution when no matching entry  in the dictionary is found. See details.}

\item{na.value}{Vector of length one speciyfing value for alleles with
no matching entry in \code{dictionary}. Default is to use \code{0}.}

\item{nacols.rm}{Logical indicating if result columns that contain only
\code{NA} should be removed.}
}
\value{
Data frame with variable number of columns. First column named 
  \code{"ID"} corresponds to \code{"ID"} column in \code{hla_calls}, further
  columns holds converted HLA variables.
}
\description{
\code{hlaToVariable} converts HLA calls data frame to additional variables.
}
\details{
\code{dictionary} file should be a tsv format with header and two columns.
First column should hold allele numbers and second corresponding additional
variables. Optionally a data frame formatted in the same manner can be passed
instead.

\code{dictionary} can be also used to access dictionaries shipped with the
package. They can be referred to by using one of the following strings:
\describe{
  \item{\code{"allele_HLA_Bw"}}{
    Translates HLA-B alleles together with A*23, A*24 and A*32 into Bw4 and
    Bw6 allele groups. In some cases HLA alleles containing Bw4 epitope, on
    nucleotide level actually carries a premature stop codon. Meaning that
    although on nucleotide level the allele would encode a Bw4 epitope it's
    not really there and it is assigned to Bw6 group. However in 4-digit
    resolution these alleles can not be distinguished from other Bw4 groups.
    Since alleles with premature stop codons are rare, Bw4 group is assigned.
  }
  \item{\code{"allele_HLA-B_only_Bw"}}{
    Translates HLA-B alleles (without A*23, A*24 and A*32) into Bw4 and Bw6
    allele groups.
  }
  \item{\code{"allele_HLA-C_C1-2"}}{
    Translates HLA-C alleles into C1 and C2 allele groups.
  }
  \item{\code{"allele_HLA_supertype"}}{
   Translates HLA-A and HLA-B alleles into supertypes, a classification that
   group HLA alleles based on peptide binding specificities.
  }
  \item{\code{"allele_HLA_Ggroup"}}{
    Translates HLA alleles into G groups, which defines amino acid identity
    only in the exons relevant for peptide binding. Note that alleles
    DRB1*01:01:01 and DRB1*01:16 match more than one G group, here this
    ambiguity was removed by deleting matching with DRB5*01:01:01G group.
  }
}

\code{reduce} control if conversion should happen in a greedy way, such that
if some HLA number cannot be converted, it's resolution is reduced by 2 and
another attempt is taken. This process stops when alleles cannot be further
reduced or all have been successfully converted.
}
\examples{
hlaToVariable(MiDAS_tut_HLA, dictionary = "allele_HLA_supertype")

}
