% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsingFunctions.R
\name{readHlaCalls}
\alias{readHlaCalls}
\title{Read HLA allele calls}
\usage{
readHlaCalls(file, resolution = 4, na.strings = c("Not typed", "-", "NA"))
}
\arguments{
\item{file}{Path to input file.}

\item{resolution}{Number specifying desired resolution.}

\item{na.strings}{a character vector of strings which are to be
    interpreted as \code{\link{NA}} values.  Blank fields are also
    considered to be missing values in logical, integer, numeric and
    complex fields.  Note that the test happens \emph{after} 
    white space is stripped from the input, so \code{na.strings} 
    values may need their own white space stripped in advance.}
}
\value{
HLA calls data frame. First column hold sample IDs, further columns 
  hold HLA allele numbers.
}
\description{
\code{readHlaCalls} read HLA allele calls from file
}
\details{
Input file has to be a tsv formatted table with a header. First column should
contain sample IDs, further columns hold HLA allele numbers. See
\code{system.file("extdata", "MiDAS_tut_HLA.txt", package = "midasHLA")} file
for an example.

\code{resolution} parameter can be used to reduce HLA allele numbers. If
reduction is not needed \code{resolution} can be set to 8. \code{resolution}
parameter can take the following values: 2, 4, 6, 8. For more details
about HLA allele numbers resolution see
\url{http://hla.alleles.org/nomenclature/naming.html}.
}
\examples{
file <- system.file("extdata", "MiDAS_tut_HLA.txt", package = "midasHLA")
hla_calls <- readHlaCalls(file)

}
