% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcNhoodExpression.R
\name{calcNhoodExpression}
\alias{calcNhoodExpression}
\title{Average expression within neighbourhoods}
\usage{
calcNhoodExpression(x, assay = "logcounts", subset.row = NULL, exprs = NULL)
}
\arguments{
\item{x}{A \code{Milo} object with \code{nhoods} slot populated, alternatively a NxM indicator matrix
of N cells and M nhoods.}

\item{assay}{A character scalar that describes the assay slot to use for calculating neighbourhood expression.}

\item{subset.row}{A logical, integer or character vector indicating the rows
of \code{x} to use for sumamrizing over cells in neighbourhoods.}

\item{exprs}{If \code{x} is a list of neighbourhoods, \code{exprs} is a matrix of genes X
cells to use for calculating neighbourhood expression.}
}
\value{
A \code{\linkS4class{Milo}} object with the \code{nhoodExpression} slot populated.
}
\description{
This function calculates the mean expression of each feature in the
Milo object stored in the assays slot. Neighbourhood expression data are
stored in a new slot \code{nhoodExpression}.
}
\details{
This function computes the mean expression of each gene, subset by \code{subset.rows}
where present, across the cells contained within each neighbourhood.
}
\examples{
require(SingleCellExperiment)
m <- matrix(rnorm(100000), ncol=100)
milo <- Milo(SingleCellExperiment(assays=list(logcounts=m)))
milo <- buildGraph(m, k=20, d=30)
milo <- makeNhoods(milo)
milo <- calcNhoodExpression(milo)
dim(nhoodExpression(milo))

}
\author{
Mike Morgan
}
