% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampCorRnaMirna.R
\name{sampCorRnaMirna}
\alias{sampCorRnaMirna}
\title{sampCorRnaMirna sampling for correlation for miRNA and mRNA}
\usage{
sampCorRnaMirna(
  mRNA,
  miRNA,
  method = "pearson",
  Shrounds = 100,
  Srounds = 1000
)
}
\arguments{
\item{mRNA}{mRNA file generated from fold changes (FC) obj of the one2OneRnaMiRNA.}

\item{miRNA}{miRNA file generated from fold changes (FC) obj of the one2OneRnaMiRNA.}

\item{method}{Default is "pearson" else use "kendall" or "spearman".}

\item{Shrounds}{number of shuffling over the FC data, default is 100.}

\item{Srounds}{number of sampling from the shuffled data, default is 1000.}
}
\value{
Correlation data frame
}
\description{
This function uses the output of one2OneRnaMiRNA and returns a sampled from original file
correlation dataframe depending on user sampling selection.
}
\examples{
x <- sampCorRnaMirna(mRNA_fc, miRNA_fc, method = "pearson", Shrounds = 10, Srounds = 10)
}
\keyword{correlation,}
\keyword{sampling,}
\keyword{shuffling}
