% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_improvement_stats}
\alias{plot_improvement_stats}
\title{Plot observed performance and improvement per target}
\usage{
plot_improvement_stats(
  misty.results,
  measure = c("gain.R2", "multi.R2", "intra.R2", "gain.RMSE", "multi.RMSE", "intra.RMSE"),
  trim = -Inf
)
}
\arguments{
\item{misty.results}{a results list generated by
\code{\link{collect_results}()}.}

\item{measure}{performance measure to be plotted (See
\code{\link{collect_results}()}).}

\item{trim}{display targets with performance value above (if R2 or gain) or
below (otherwise) this value only.}
}
\value{
The \code{misty.results} list (invisibly).
}
\description{
Generates a plot of the mean (+- standard deviation) of the performance value
per target across all samples from the results.
}
\examples{
all.samples <- list.dirs("results", recursive = FALSE)

collect_results(all.samples) \%>\% plot_improvement_stats()

misty.results <- collect_results(all.samples)
misty.results \%>\% plot_improvement_stats(measure = "gain.RMSE")
misty.results \%>\% plot_improvement_stats(measure = "intra.R2")
}
\seealso{
\code{\link{collect_results}()} to generate a
    results list from raw results.

Other plotting functions: 
\code{\link{plot_contrast_heatmap}()},
\code{\link{plot_contrast_results}()},
\code{\link{plot_interaction_communities}()},
\code{\link{plot_interaction_heatmap}()},
\code{\link{plot_view_contributions}()}
}
\concept{plotting functions}
