% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_and_plot.R
\name{mitoTreeHeatmap}
\alias{mitoTreeHeatmap}
\title{Circular heatmap on mitochondrial gene set tree.}
\usage{
mitoTreeHeatmap(
  data,
  database = "MitoCarta",
  sections = FALSE,
  samples = NULL,
  labelNames = "sections",
  ...
)
}
\arguments{
\item{data}{matrix or data.frame with samples in columns and mitochondrial 
gene sets in rows.}

\item{database}{character string saying the database used for the analysis.
Either one of "MitoCarta", "Reactome", "GO-CC" and "GO-BP".}

\item{sections}{logical. Either to keep the aggregated gene set categories 
or the specific gene sets. Default is FALSE.}

\item{samples}{character vector with the names of samples to be plotted.
Otherwise all samples are plotted.}

\item{labelNames}{character string that says to plot either the names of 
"sections" or "leaves".}

\item{...}{other arguments passed on to the \code{\link[ggtree]{gheatmap}}
function.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Given a matrix of scores, it returns a circular heatmap of
the mitochondrial gene sets (leaf of the database tree) or gene set 
groups (section of the database tree).
}
\examples{
MClist <- getGeneSets()
n <- length(names(MClist)) * 5
rmatrix <- matrix(rnorm(n, 0), ncol = 5)
rownames(rmatrix) <- names(MClist)
colnames(rmatrix) <- paste0("Sample_", seq_len(5))
mitoTreeHeatmap(data = rmatrix, database = "MitoCarta")

}
