% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{biplot}
\alias{biplot}
\alias{biplot.pca}
\alias{biplot.mixo_pls}
\title{biplot methods for \code{pca} family}
\usage{
\method{biplot}{pca}(
  x,
  comp = c(1, 2),
  block = NULL,
  ind.names = TRUE,
  group = NULL,
  cutoff = 0,
  col = NULL,
  ind.names.size = 3,
  ind.names.col = color.mixo(4),
  ind.names.repel = TRUE,
  pch = 19,
  pch.size = 2,
  var.names = TRUE,
  var.names.col = "grey40",
  var.names.size = 4,
  var.names.angle = FALSE,
  var.arrow.col = "grey40",
  var.arrow.size = 0.5,
  var.arrow.length = 0.2,
  ind.legend.title = NULL,
  vline = FALSE,
  hline = FALSE,
  legend = if (is.null(group)) FALSE else TRUE,
  legend.title = NULL,
  pch.legend.title = NULL,
  cex = 1.05,
  ...
)

\method{biplot}{mixo_pls}(
  x,
  comp = c(1, 2),
  block = NULL,
  ind.names = TRUE,
  group = NULL,
  cutoff = 0,
  col = NULL,
  ind.names.size = 3,
  ind.names.col = color.mixo(4),
  ind.names.repel = TRUE,
  pch = 19,
  pch.size = 2,
  var.names = TRUE,
  var.names.col = "grey40",
  var.names.size = 4,
  var.names.angle = FALSE,
  var.arrow.col = "grey40",
  var.arrow.size = 0.5,
  var.arrow.length = 0.2,
  ind.legend.title = NULL,
  vline = FALSE,
  hline = FALSE,
  legend = if (is.null(group)) FALSE else TRUE,
  legend.title = NULL,
  pch.legend.title = NULL,
  cex = 1.05,
  ...
)
}
\arguments{
\item{x}{An object of class 'pca'or mixOmics '(s)pls'.}

\item{comp}{integer vector of length two (or three to 3d). The components
that will be used on the horizontal and the vertical axis respectively to
project the individuals.}

\item{block}{Character, name of the block to show for \code{pls} object.
Default to \code{'X'}.}

\item{ind.names}{either a character vector of names for the individuals to
be plotted, or \code{FALSE} for no names. If \code{TRUE}, the row names of
the first (or second) data matrix is used as names (see Details). If `pch` is set this
will overwrite the names as shapes. Default is \code{TRUE}. 
Not avaliable for MINT objects.}

\item{group}{Factor indicating the group membership for each sample.}

\item{cutoff}{numeric between 0 and 1. Variables with correlations below
this cutoff in absolute value are not plotted (see Details).}

\item{col}{character (or symbol) color to be used. If \code{group} provided, should be a 
vector of the same length as groups, order of colours will be respected to correspond to 
order of \code{group} levels.}

\item{ind.names.size}{Numeric, sample name size.}

\item{ind.names.col}{Character, sample name colour.}

\item{ind.names.repel}{Logical, whether to repel away label names.}

\item{pch}{A single character or numeric value, or a factor. If a factor, the
levels of the factor are used to define the point types. If a character or
numeric value, the same point type is used for all points. If \code{NULL},
the default point type is used. See examples.}

\item{pch.size}{Numeric, sample point character size.}

\item{var.names}{Logical indicating whether to show variable names. 
Alternatively, a character.}

\item{var.names.col}{Character, variable name colour.}

\item{var.names.size}{Numeric, variable name size.}

\item{var.names.angle}{Logical, whether to align variable names to arrow
directions.}

\item{var.arrow.col}{Character, variable arrow colour. If 'NULL', no arrows
are shown.}

\item{var.arrow.size}{Numeric, variable arrow head size.}

\item{var.arrow.length}{Numeric, length of the arrow head in 'cm'.}

\item{ind.legend.title}{Character, title of the legend.}

\item{vline}{Logical, whether to draw the vertical neutral line.}

\item{hline}{Logical, whether to draw the horizontal neutral line.}

\item{legend}{Logical, whether to show the legend if \code{group != NULL}.}

\item{legend.title}{Character, the legend title if \code{group != NULL}.}

\item{pch.legend.title}{Character, the legend title if \code{pch} is a factor.}

\item{cex}{Numeric scalar indicating the desired magnification of plot texts.
\code{\link[ggplot2]{theme}} function may be used with the output object if
further customisation is required.}

\item{...}{Not currently used.}

\item{pch.legend}{Character, the legend title if \code{pch} is a factor.}
}
\value{
A ggplot object.
}
\description{
biplot methods for \code{pca} family
}
\details{
\code{biplot} unifies the reduced representation of both the
observations/samples and variables of a matrix of multivariate data on the
same plot. Essentially, in the reduced space the samples are shown as
points/names and the contributions of features to each dimension are shown as
directed arrows or vectors.
For \code{pls} objects it is possible to use either \code{'X'} or \code{'Y'}
latent space using \code{block} argument.
}
\examples{

## 'pca' class - examples demonstrate how to control sample colours and customise plots
# -------------------------------------------------------------------------------------
set.seed(42)
data("nutrimouse")
pca.lipid <- pca(nutrimouse$lipid, ncomp = 3, scale = TRUE)

# colors indicate diet
biplot(pca.lipid, group = nutrimouse$diet)

# colors indicate genotype
biplot(pca.lipid, group = nutrimouse$genotype)

# customise colours
biplot(pca.lipid, group = nutrimouse$genotype,
       col = c("red", "blue"))

## correlation cutoff to filter features
biplot(pca.lipid, cutoff = c(0.8))

## tailor threshold for each component
biplot(pca.lipid, cutoff = c(0.8, 0.7))

## customise components
biplot(pca.lipid, cutoff = c(0.8), comp = c(1,3))

## customise ggplot in an arbitrary way
biplot(pca.lipid) + theme_linedraw() + 
    # add vline
    geom_vline(xintercept = 0, col = 'green') +
    # add hline
    geom_hline(yintercept = 0, col = 'green') +
    # customise labs
    labs(x = 'Principal Component 1', y = 'Principal Component 2')

## customise variable labels
biplot(pca.lipid, 
       var.names.col = color.mixo(2),
       var.names.size = 4,
       var.names.angle = TRUE
)

## no arrows
biplot(pca.lipid, group = nutrimouse$diet, legend.title = 'Diet', 
       var.arrow.col = NULL, var.names.col = 'black')

## add x=0 and y=0 lines in function
biplot(pca.lipid, group = nutrimouse$diet, legend.title = 'Diet', 
       var.arrow.col = NULL, var.names.col = 'black', 
       vline = TRUE, hline = TRUE)

## 'pls' class - examples demonstrate how to control cutoffs
# -------------------------------------------------------------------------------------

data("nutrimouse")
pls.nutrimouse <- pls(X = nutrimouse$gene, Y = nutrimouse$lipid, ncomp = 2)

biplot(pls.nutrimouse, group = nutrimouse$genotype, block = 'X',
       legend.title = 'Genotype', cutoff = 0.878) 

biplot(pls.nutrimouse, group = nutrimouse$genotype, block = 'Y',
       legend.title = 'Genotype', cutoff = 0.8) 


## 'plsda' class - examples demonstrate how to control point shapes
# -------------------------------------------------------------------------------------

data(breast.tumors)
X <- breast.tumors$gene.exp
colnames(X) <- paste0('GENE_', colnames(X))
rownames(X) <- paste0('SAMPLE_', rownames(X))
Y <- breast.tumors$sample$treatment
nrow(X)
grouping <- factor(c(rep("A", 20), rep("B", 20), rep("C", 7)))

plsda.breast <- plsda(X, Y, ncomp = 2)

biplot(plsda.breast, cutoff = 0.72, ind.names = FALSE)

biplot(plsda.breast, cutoff = 0.72, ind.names = FALSE, pch = 2, pch.size = 5)

biplot(plsda.breast, cutoff = 0.72, pch = grouping, pch.size = 5)

}
\author{
Al J Abadi
}
