% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{createApp}
\alias{createApp}
\title{Creating app data.}
\usage{
createApp(
  sets = seq_len(3),
  m = NULL,
  n = NULL,
  o = NULL,
  maxk = 5,
  parallel = NULL,
  path = "",
  types = c("data", "lods", "mnem"),
  allcrop = FALSE,
  multi = FALSE,
  file = NULL,
  ...
)
}
\arguments{
\item{sets}{numeric vector with the data sets: 1 (CROPseq),
2, 3 (both PERTURBseq); default is all three}

\item{m}{number of Sgenes (for testing)}

\item{n}{number of most variable E-genes (for testing)}

\item{o}{number of samples per S-gene (for testing)}

\item{maxk}{maximum number of component in mnem inference (default: 5)}

\item{parallel}{number of threads for parallelisation}

\item{path}{path to the data files path/file.csv: "path/"}

\item{types}{types of data/analysis; "data" creates the gene expression
matrix, "lods" includes the log odds, "mnem" additionally performes the
mixture nem analysis; default c("data", "lods", "mnem")}

\item{allcrop}{if TRUE, does not restrict and uses the full CROPseq dataset}

\item{multi}{if TRUE, includes cells with more than one perturbed gene}

\item{file}{path and filename of the rda file with the raw data from the
command "data <- createApp(..., types = "data")"}

\item{...}{additional parameters for the mixture nem function}
}
\value{
app data object
}
\description{
This function is for the reproduction of the application
results in the vignette and publication. See the publication
Pirkl & Beerenwinkel (2018) on how to download the data files:
GSE92872_CROP-seq_Jurkat_TCR.digital_expression.csv
k562_both_filt.txt
GSM2396861_k562_ccycle_cbc_gbc_dict.csv
GSM2396858_k562_tfs_7_cbc_gbc_dict.csv
}
\examples{
## recreate the app data object (takes very long, i.e. days)
\dontrun{
createApp()
}
data(app)
}
\author{
Martin Pirkl
}
