% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{nem}
\alias{nem}
\title{Implementation of the original NEM}
\usage{
nem(
  D,
  search = "greedy",
  start = NULL,
  method = "llr",
  marginal = FALSE,
  parallel = NULL,
  reduce = FALSE,
  weights = NULL,
  runs = 1,
  verbose = FALSE,
  redSpace = NULL,
  trans.close = TRUE,
  subtopo = NULL,
  prior = NULL,
  ratio = TRUE,
  domean = TRUE,
  modulesize = 5,
  fpfn = c(0.1, 0.1),
  Rho = NULL,
  logtype = 2,
  modified = FALSE,
  tree = FALSE,
  learnRates = FALSE,
  stepSize = 0.01,
  ...
)
}
\arguments{
\item{D}{data matrix with observed genes as rows and knock-down
experiments as columns}

\item{search}{either "greedy", "modules" or "exhaustive" (not
recommended for more than five S-genes)}

\item{start}{either NULL ("null") or a specific network to start
the greedy}

\item{method}{"llr" for log odds or p-values densities or "disc"
for binary data}

\item{marginal}{logical to compute the marginal likelihood (TRUE)}

\item{parallel}{NULL for no parallel optimization or an integer
for the number of threads}

\item{reduce}{reduce search space (TRUE) for exhaustive search}

\item{weights}{a numeric vector of weights for the columns of D}

\item{runs}{the number of runs for the greedy search}

\item{verbose}{for verbose output (TRUE)}

\item{redSpace}{reduced search space for exhaustive search;
see result of exhaustive
search with reduce = TRUE}

\item{trans.close}{if TRUE uses the transitive closure of adj}

\item{subtopo}{optional matrix with the subtopology theta as
adjacency matrix}

\item{prior}{a prior network matrix for adj}

\item{ratio}{if FALSE uses alternative distance for the model score}

\item{domean}{if TRUE summarizes duplicate columns}

\item{modulesize}{the max number of S-genes included in one module
for search = "modules"}

\item{fpfn}{numeric vector of length two with false positive and
false negative rates}

\item{Rho}{optional perturbation matrix}

\item{logtype}{log base of the log odds}

\item{modified}{if TRUE, assumes a preprocessed data matrix}

\item{tree}{if TRUE forces tree; does not allow converging edges}

\item{learnRates}{if TRUE learns rates for false positives/negatives}

\item{stepSize}{numerical step size for learning rates}

\item{...}{optional parameters for future search methods}
}
\value{
transitively closed matrix or graphNEL
}
\description{
Infers a signalling pathway from perturbation experiments.
}
\examples{
D <- matrix(rnorm(100*3), 100, 3)
colnames(D) <- 1:3
rownames(D) <- 1:100
adj <- diag(3)
colnames(adj) <- rownames(adj) <- 1:3
scoreAdj(D, adj)
}
\author{
Martin Pirkl
}
