% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_validation.R
\name{consensus_matrix}
\alias{consensus_matrix}
\title{Compute consensus matrix from labels}
\usage{
consensus_matrix(labels, scale = TRUE)
}
\arguments{
\item{labels}{a matrix with each column corresponding to a the results of a
single clustering routine. Each column should give the cluster assignment
FIXME: What is the required format of entries??}

\item{scale}{boolean, optional, default: TRUE. Whether to rescale the
resulting consensus matrix so that entries correspond to proportions.}
}
\value{
a symmetric matrix of size NxN, where N is the number of rows of the
 input matrix \code{labels}. Each i,j entry of the matrix corresponds the
 number of times the two rows were in the same cluster across the clusterings
 (\code{scale=FALSE}) or the proportion of clustering that the two rows are
 in the same cluster (\code{scale=TRUE}).
}
\description{
Compute consensus matrix from labels
}
\examples{
data(exampleData)
moanin <- create_moanin_model(data=testData,meta=testMeta)
#small function to run splines_kmeans on subsample of 50 genes
subsampleCluster<-function(){
   ind<-sample(1:nrow(moanin),size=50,replace=FALSE)
   km<-splines_kmeans(moanin[ind,],n_clusters=3)
   assign<-splines_kmeans_predict(moanin,km, 
      method="distance")
  }
kmClusters=replicate(10,subsampleCluster())
cm<-consensus_matrix(kmClusters)
heatmap(cm)
}
