% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfm_comparison.R
\name{motifSimilarity}
\alias{motifSimilarity}
\title{Calculate similarities between pairs of motifs.}
\usage{
motifSimilarity(
  x,
  y = NULL,
  method = c("R", "HOMER"),
  homerfile = findHomer("compareMotifs.pl"),
  homerOutfile = NULL,
  BPPARAM = SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{x}{Either a \code{\link[TFBSTools]{PFMatrixList}}, or a character
scalar with a file containing motifs in HOMER format (used directly
\code{method = "HOMER"}, loaded into a
\code{\link[TFBSTools]{PFMatrixList}} by \code{\link{homerToPFMatrixList}}
for \code{method = "R"}).}

\item{y}{Either a \code{\link[TFBSTools]{PFMatrixList}} or \code{NULL}
(default). If \code{y = NULL}, then similarities will be calucalted for all
pairs of motifs within \code{x}. Otherwise, \code{method} must be
\code{"R"} and similarities will be calculated between any motif from
\code{x} to any motif from \code{y}.}

\item{method}{A character scalar specifying the method for similarity
calculations. Either \code{"R"} (pure R implementation) or \code{"HOMER"}
(will call the \code{compareMotifs.pl} script from HOMER). Results are
identical (apart from rounding errors), and the R implementation is
usually faster and can be parallelized (\code{BPPARAM} argument).}

\item{homerfile}{Path to the HOMER script \code{compareMotifs.pl} (only used
for \code{method = "HOMER"}.}

\item{homerOutfile}{A character scalar giving the file to save the similarity
scores (only for \code{metho = "HOMER"}). If \code{NULL}, scores will be
stored into a temporary file.}

\item{BPPARAM}{An optional \code{\link[BiocParallel]{BiocParallelParam}}
instance determining the parallel back-end to be used during evaluation
(only used for \code{method = "R"}).}

\item{verbose}{A logical scalar. If \code{TRUE}, report on progress.}
}
\value{
A matrix of Pearson's correlation coefficients for each pair of
  motifs.
}
\description{
For each pair of motifs, calculate the similarity defined as the
  maximal Pearson's correlation coefficient between base frequencies over all
  possible shifts (relative positions of the two matrices with at least one
  overlapping position). If necessary matrices are padded on the sides with
  background base frequencies (assuming all bases to have a frequency of
  0.25) to enable comparison of all positions in both matrices.
}
\examples{
m <- rbind(A = c(12,  0,  0),
           C = c( 3,  2,  0),
           G = c( 0, 14,  0),
           T = c( 0,  0, 15))
pfms <- TFBSTools::PFMatrixList(
    TFBSTools::PFMatrix(name = "m1", profileMatrix = m),
    TFBSTools::PFMatrix(name = "m2", profileMatrix = m + 10),
    TFBSTools::PFMatrix(name = "m3", profileMatrix = m[, 3:1])
)
motifSimilarity(pfms)

}
\seealso{
\code{\link[BiocParallel]{bplapply}} used for parallelization for
  \code{method = "R"},
  documentation of HOMER's \code{compareMotifs.pl} for details on
  \code{method = "HOMER"}.
}
