% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forground_wrapper.R
\name{motifAndBackgroundValid}
\alias{motifAndBackgroundValid}
\title{Check valididity of PFM with background}
\usage{
motifAndBackgroundValid(pfm, bg)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
None
}
\description{
This function checks if the PFM x background combination is valid.
The function throws an error if this is not the case.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x1.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Check validity
motifcounter:::motifAndBackgroundValid(motif, bg)

}
