% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option.R
\name{motifcounterOptions}
\alias{motifcounterOptions}
\title{Set parameters for the enrichment analysis}
\usage{
motifcounterOptions(alpha = 0.001, gran = 0.1, ncores = 1)
}
\arguments{
\item{alpha}{Numeric False positive probabililty for calling
motif hits by chance. Default: alpha = 0.001}

\item{gran}{Numeric score granularity which is used
for discretizing the score range. Default: gran = 0.1}

\item{ncores}{Interger number of cores used for parallel processing,
if openMP is available. Default: ncores = 1}
}
\value{
None
}
\description{
This function sets some global parameters for
the `motifcounter` package.
}
\details{
alpha=0.001 amounts to calling 
one motif hit per strand by chance in a sequence of length 1000 bp. 
Decreasing gran will increase number
of discrete bins that represent the real-valued score range.
This will yield more a accurate score distribution due to less
discretization noise, however, it incurs an 
increase of the computational burden.
}
\examples{

# Prescribe motifcounter Options
motifcounterOptions(alpha = 0.001, gran = 0.1, ncores = 1)

}
