% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag-filter-remove.R
\name{flag_remove}
\alias{flag_remove}
\title{Flag and remove unwanted peaks}
\usage{
flag_remove(
  xcmsObj,
  pol = NA,
  rsd_i_blank = NA,
  minfrac_blank = 0.5,
  rsd_rt_blank = NA,
  ithres_blank = NA,
  s2b = 10,
  ref.class = "blank",
  egauss_thr = NA,
  rsd_i_sample = NA,
  minfrac_sample = 0.7,
  rsd_rt_sample = NA,
  ithres_sample = NA,
  minfrac_xcms = 0.7,
  mzwid = 0.017,
  bw = 5,
  out_dir = ".",
  temp_save = FALSE,
  remove_spectra_bool = TRUE,
  grp_rm_ids = NA,
  xset = NA
)
}
\arguments{
\item{xcmsObj}{object; XCMSnExp, xcmsSet or xsAnnotate object}

\item{pol}{str; polarity (just used for naming purpose for files being saved) [positive, negative, NA]}

\item{rsd_i_blank}{numeric; RSD threshold for the blank}

\item{minfrac_blank}{numeric; minimum fraction of files for features needed for the blank}

\item{rsd_rt_blank}{numeric; RSD threshold for the RT of the blank}

\item{ithres_blank}{numeric; Intensity threshold for the blank}

\item{s2b}{numeric; fold change (sample/blank) needed for sample peak to be allowed. e.g.
if s2b set to 10 and the recorded sample 'intensity' value was 100 and blank = 10.
1000/10 = 100 so sample has fold change higher than the threshold and the peak is not considered a blank}

\item{ref.class}{str; A string representing the class that will be used for the blank.}

\item{egauss_thr}{numeric; Threshold for filtering out non gaussian shaped peaks. Note this only works
if the verbose option was set for XCMS;}

\item{rsd_i_sample}{numeric; RSD threshold for the sample}

\item{minfrac_sample}{numeric; minimum fraction of files for features needed for the sample}

\item{rsd_rt_sample}{numeric; RSD threshold for the RT of the sample}

\item{ithres_sample}{numeric; Intensity threshold for the sample}

\item{minfrac_xcms}{numeric; minfrac for xcms  grouping}

\item{mzwid}{numeric; xcms grouping parameter (corresponds to variable 'binSize' in XCMS3)}

\item{bw}{numeric; xcms grouping parameter}

\item{out_dir}{str; out directory}

\item{temp_save}{boolean; Assign True if files for each step saved (for testing purpsoses)}

\item{remove_spectra_bool}{bool; TRUE if flagged spectra is to be removed}

\item{grp_rm_ids}{vector; vector of grouped_xcms peaks to remove (corresponds to the row from xcms::group output)}

\item{xset}{object, DEPRECATED; xcmsSet object}
}
\value{
list(xset, grp_peaklist, removed_peaks)
}
\description{
Filter, flag and remove unwanted peaks from xcms object (xcmsObj) of class XCMSnExp, xcmsSet or xsAnnotate.
When the peaks are removed, the xcmsObj object can be regrouped (originally using xcms::group, now using xcms::groupChromPeaks).
The function then checks if any blank peaks are still present and the process is repeated.

The output is a list object containing: 1) the updated xcms object, 2) the grouped peaklist and 3) the blank removed peaks
}
\examples{
library(xcms)
library(MSnbase)
library(magrittr)
#read in files and data
msPths <-list.files(system.file("extdata", "lcms", "mzML", package="msPurityData"), full.names = TRUE)
ms_data = readMSData(msPths, mode = 'onDisk', msLevel. = 1)

#subset the data to focus on retention times 30-90 seconds and m/z values between 100 and 200 m/z.
rtr = c(30, 90)
mzr = c(100, 200)
ms_data = ms_data \%>\%  filterRt(rt = rtr) \%>\%  filterMz(mz = mzr)

##### perform feature detection in individual files
cwp <- CentWaveParam(snthresh = 3, noise = 100, ppm = 10, peakwidth = c(3, 30))
xcmsObj <- findChromPeaks(ms_data, param = cwp)
xcmsObj@phenoData@data$class = c('blank', 'blank', 'sample', 'sample')
xcmsObj@phenoData@varMetadata = data.frame('labelDescription' = 'sampleNames', 'class')
pdp <- PeakDensityParam(sampleGroups = xcmsObj@phenoData@data$class, minFraction = 0, bw = 5, binSize = 0.017)
xcmsObj <- groupChromPeaks(xcmsObj, param = pdp)

#### flag, filter and remove peaks, returning an updated xcmsObj (XCMSnExp or xcmsSet class), grouped_peaklist (data.frame) and removed_peaks (data.frame)
fr <- flag_remove(xcmsObj)

##### load from existing data
xcmsObj = readRDS(system.file("extdata", "tests", "purityA", "10_input_filterflagremove.rds", package="msPurity"))




}
