% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{get_multimir}
\alias{get_multimir}
\alias{get.multimir}
\title{Get microRNA-target Interactions from the multiMiR Package}
\usage{
get_multimir(url = NULL, org = "hsa", mirna = NULL, target = NULL,
  disease.drug = NULL, table = "validated", predicted.cutoff = NULL,
  predicted.cutoff.type = "p", predicted.site = "conserved",
  summary = FALSE, add.link = FALSE, use.tibble = FALSE, limit = NULL,
  legacy.out = FALSE)

get.multimir(url = NULL, org = "hsa", mirna = NULL, target = NULL,
  disease.drug = NULL, table = "validated", predicted.cutoff = NULL,
  predicted.cutoff.type = "p", predicted.site = "conserved",
  summary = FALSE, add.link = FALSE, use.tibble = FALSE, limit = NULL)
}
\arguments{
\item{url}{Deprecated. The URL for queries is now defined by the package
options \code{multimir.url} and \code{multimir.queries}.}

\item{org}{a character string for the organism. Three organisms are
supported so far: human ("hsa" (default), "human", or "Homo Sapiens"), mouse
("mmu", "mouse", or "Mus musculus"), and rat ("rno", "rat", or "Rattus
norvegicus"). The organism is case insensitive.}

\item{mirna}{'NULL' (default) or a character string or character vector for
the mature miRNA(s). It can be the mature miRNA accession number (i.e.
"MIMAT0000072"), mature miRNA ID (i.e. "hsa-miR-199a-3p"), or a combination
of both (i.e. c("MIMAT0000065", "hsa-miR-30a-5p")).  The character is case
insensitive. *See note about the length of list supported.}

\item{target}{'NULL' (default) or a character string or character vector for
the target gene(s). It can be the gene symbol (i.e. c("TP53", "KRAS")),
Entrez gene ID (i.e. c(578, 3845)), Ensembl gene ID (i.e.
"ENSG00000171791"), or a combination of any of these identifiers (i.e.
c("TP53", 3845, "ENSG00000171791")). The character is case insensitive. *See
note about the length of list supported.}

\item{disease.drug}{'NULL' (default) or a character string or character
vector for the disease(s) and/or drug(s) (i.e. c("bladder cancer",
"cisplatin")).  The character is case insensitive.}

\item{table}{a character string indicating which table(s) in multiMiR to
search. Each table contains data from an external database.  Options include
"validated" (default, to search all validated tables "mirecords",
"mirtarbase", and "tarbase"), "predicted" (to search all predicted tables
"diana_microt", "elmmo", "microcosm", "miranda", "mirdb", "pictar", "pita",
and "targetscan"), "disease.drug" (to search all disease/drug tables
"mir2disease", "pharmaco_mir", and "phenomir"), "all" (to search all of the
tables above), or an individual table from above.}

\item{predicted.cutoff}{'NULL' (default) or an integer giving a prediction
score cutoff.  By default ('NULL'), the cutoff is '20' (search the top 20\%
if \code{predicted.cutoff.type="p"}) or '300000' (search the top 300000 (or
all records if total < 300000) if \code{predicted.cutoff.type="n"}).}

\item{predicted.cutoff.type}{a character indicating the type of prediction
score cutoff. This must be either "p" (default, percentage cutoff) or "n"
(number cutoff).}

\item{predicted.site}{a character string indicating the type of predicted
target sites to search. This can be one of the strings "conserved",
"nonconserved", or "all", and can be abbreviated. This only applies to three
of the predicted tables ("miranda", "pita", and "targetscan") that have
conservation information of the target sites.}

\item{summary}{logical. Whether to summarize the result (default = FALSE).}

\item{add.link}{logical. Whether to add link to external database for each
result entry.}

\item{use.tibble}{logical. Whether to use the data_frame class from the
tibble package for returned dataframes.  The key benefit for large datasets
is more restrictive printing to the console (first 10 rows and only the
number of columns that will fit \code{getOption('width')}). See
\code{?tible::data_frame} for more information.}

\item{limit}{a positive integer. Limits the number of records returned from
each table.  Useful in testing potentially large queries.}

\item{legacy.out}{logical. Whether to return the Bioconductor compatible S4
object or the legacy S3 object (default=FALSE).}
}
\value{
\code{get_multimir} returns an S4 object (see
\code{?mmquery_bioc-class} containing the queried data and associated
metadata. With \code{legacy.out=FALSE} (default), the data is a single
dataset with association/interaction type defined by the \code{type}
variable. With \code{legacy.out=TRUE} the original S3 object with 3 separate
data frames ('predicted', 'validated', and 'disease_drug') is returned.
}
\description{
The main function to retrieve predicted and validated miRNA-target
interactions and their disease and drug associations from the multiMiR
package.
}
\details{
get.multimir() has been deprecated and replaced with the get_multimir()
version.

\code{get_multimir} is the main and recommended function to retrieve
information from the multiMiR package. Input to the function must contain at
least one of the followings: miRNA(s), target gene(s), and disease and drug
term(s).

The setting of \code{predicted.site} is applicable to three ("miranda",
"pita", and "targetscan") of the eight predicted tables.  If
\code{predicted.site} is \code{"conserved"}, the function will search
conserved target sites annotated by TargetScan, target sites with
conservation scores greater than or equal to 0.57 (in human and rat; or
0.566 in mouse) in miRanda, and/or sites with conservation scores greater
than or equal to 0.9 in PITA.

Although the summary (if \code{summary=TRUE}) can be used to find results
that are recorded by combinations of different databases, please note that
for predicted interactions a combination approach may not be as effective as
a single algorithm because of age or quality of the tool.

Note: The length of the list supported has been increased from version1.0.1.
The size is now limited to 20MB which should accommodate most requests.
There is a possibility for technical reasons that the query could fail even
if the list is under this limit.  If this occurs it is recommended that you
break up the list into smaller batches and submit them sequentially.
}
\examples{

  ## search 'hsa-miR-18a-3p' in validated interactions in human
  example1 <- get_multimir(mirna='hsa-miR-18a-3p', summary=TRUE)
  columns(example1)
  ## target genes that are validated by Luciferase assay
  lucif <- select(example1, keytype = "type", keys = "validated", 
                  columns = columns(example1))
  lucif[grep("Luciferase", lucif$experiment), ]
  example1@summary[example1@summary[,"target_symbol"] == "KRAS",]

  ## search 'cisplatin' in disease and drug tables in human
  example2 <- get_multimir(disease.drug='cisplatin', table='disease.drug')
  nrow(example2@data)
  head(example2@data)

}
\keyword{database}
\keyword{utilities}
