% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmquery.R
\docType{class}
\name{mmquery_bioc-class}
\alias{mmquery_bioc-class}
\alias{as.mmquery_bioc}
\alias{columns,mmquery_bioc-method}
\alias{keys,mmquery_bioc-method}
\alias{keytypes,mmquery_bioc-method}
\alias{select,mmquery_bioc-method}
\alias{show,mmquery_bioc-method}
\title{S4 constructor and methods for object returned by \code{get_multimir()}.}
\usage{
as.mmquery_bioc(.list)

\S4method{columns}{mmquery_bioc}(x)

\S4method{keys}{mmquery_bioc}(x, keytype, ...)

\S4method{keytypes}{mmquery_bioc}(x)

\S4method{select}{mmquery_bioc}(x, keys, columns, keytype, ...)

\S4method{show}{mmquery_bioc}(object)
}
\arguments{
\item{.list}{a list of returned dataframes, summary}

\item{x, object}{An mmquery_bioc object.}

\item{keytype}{allows the user to discover which keytypes can be passes in to
select or keys  and the keytype argument}

\item{...}{additional arguments}

\item{keys}{A result of the keys() function. For the mmquery_bioc class this
is a character vector of microRNA's in the returned mmquery_bioc object.}

\item{columns}{lists the columns that can be returned for the
\code{mmquery_bioc} object.}
}
\value{
an s4 object of class mmquery_bioc.  Contains queried data, a summary
dataset, and associated input parameters.
}
\description{
This package's primary user-facing object. Contains the SQL statement and the
returned data query, as well as a summary table depending on
specified option.  Note that the returned data is now contained in a single
dataframe. To filter to a specific type of association or interaction,
\code{select} on the \code{type} variable.
}
\section{Slots}{

\describe{
\item{\code{data}}{A dataframe containing validated and predicted microRNA-target
interactions and disease/drug assocations found.}

\item{\code{queries}}{A list of queries submitted to the multiMiR SQL server.}

\item{\code{summary}}{A summary dataframe of the returned microRNA dataframes}

\item{\code{tables}}{A character vector of the microRNA relationship types returned
(validated, predicted, disease.drug, or all).}

\item{\code{org}}{The selected organism (hsa/human, mmu/mouse, rno/rat).}

\item{\code{predicted.cutoff}}{An integer giving a prediction score cutoff.}

\item{\code{predicted.cutoff.type}}{A character indicating the type of prediction
score cutoff (p = percentage, n = number, character() = none)}

\item{\code{predicted.site}}{A character string indicating the type of predicted
target sites to searched.}
}}

