% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_write_ranges.R
\name{write_ranges}
\alias{write_ranges}
\alias{read_ranges}
\title{Write GRanges to file}
\usage{
write_ranges(gr, file, verbose = TRUE)

read_ranges(file, bsgenome)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{file}{file}

\item{verbose}{TRUE (default) or FALSE}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}} for read_ranges
}
\description{
Write GRanges to file
}
\examples{
# Find PE spacers for 4 clinically relevant loci (Anzalone et al, 2019)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(
        PRNP = 'chr20:4699600:+',             # snp: prion disease
        HBB  = 'chr11:5227002:-',             # snp: sickle cell anemia
        HEXA = 'chr15:72346580-72346583:-',   # del: tay sachs disease
        CFTR = 'chr7:117559593-117559595:+'), # ins: cystic fibrosis
        bsgenome)
    file <- file.path(tempdir(), 'gr.txt')
    write_ranges(gr, file)
    read_ranges(file, bsgenome)
}
