% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbHW.R
\name{bbhw}
\alias{bbhw}
\title{bbhw: Bulk-based hypothesis weighing}
\usage{
bbhw(
  pbDEA,
  bulkDEA,
  pb = NULL,
  local = TRUE,
  useSign = TRUE,
  nbins = NULL,
  bin.method = c("PAS", "combined", "asNA", "sig", "PALFC"),
  correction.method = c("gBH.LSL", "IHW", "binwise", "gBH.TST"),
  NAsep = TRUE,
  alpha = 0.1,
  nfolds = NULL,
  BPPARAM = SerialParam(progressbar = verbose),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{pbDEA}{A data.frame of pseudo-bulk DEA results, as for instance 
produced by \code{\link{pbDS}} or \code{\link{mmDS}} (specifically this 
should be a data.frame for one contrast, e.g. an element of `res$table` of 
the output). This should contain the columns "gene", "cluster_id", "p_val"
and, optionally "logFC".}

\item{bulkDEA}{A data.frame of bulk DEA results, with gene names as row.names
and including the column "p_val" and, ideally, "logFC". Alternatively, a 
named vector of significance values. Not that these samples should be 
independent form the single-cell samples on which `pbDEA` is based.}

\item{pb}{A pseudo-bulk SummarizedExperiment object as produced by 
\code{\link{aggregateData}}. Alternatively, a matrix with cell types as 
columns and gene as rows, giving the read counts or proportion of 
contribution for each gene. If neither is given, the only available methods
are "ihw.local" and "ihw.global".}

\item{local}{Logical; whether to apply the adjustment locally, i.e. 
separately for each cell type (default TRUE).}

\item{useSign}{Logical; whether to discount bulk p-values for which the 
change is in the opposite direction as in the given celltype.}

\item{nbins}{The number of significance bins to use for the covariate (i.e. 
prior). For `combIHW`, the effective number of bins will be doubled (to 
accommodate proportion-based bins). If omitted, a decent number of bins 
will be set based on the method and number of hypotheses.}

\item{bin.method}{The method for creating the bulk-based bins. Either "PAS" 
(recommended and default), "combined", or "sig". Note that only 
method="sig" is available if `pb` is not provided.}

\item{correction.method}{Determines with which method the bins are used. 
See details for the different options. We recommend "gBH.LSL".}

\item{NAsep}{Logical; whether to put NA bulk p-values into their own bin 
(assuming there is a sufficient number of them). Otherwise, NA values will 
be set to 0.5. In practice there is often an enrichment for small p-values
in genes that are undetectable at the bulk level, so we recommend setting 
this to TRUE (default).}

\item{alpha}{The nominal level for FDR control for \code{\link[IHW]{ihw}}.}

\item{nfolds}{The number of cross-validation folds, passed to 
\code{\link[IHW]{ihw}}. If null, will use appropriate defaults based on 
the number of hypotheses per bin.}

\item{BPPARAM}{An optional BiocParallel BPPARAM object for multithreading.}

\item{verbose}{Logical; whether to print helpful information.}

\item{...}{Passed to \code{\link[IHW]{ihw}}.}
}
\value{
The `pbDEA` object including extra columns, in particular the `padj`
  column.
}
\description{
This is a method to increase the power of low-sample-size, per-celltype 
differential state analysis by using a larger dataset of bulk RNAseq. In at 
nutshell, it uses bulk data to create a covariate according to which the 
hypotheses are grouped, and then uses this grouping either either on via 
independent hypothesis weighing or grouped Benjamini-Hochberg correction to
increase power.
}
\details{
This function contains different methods to create the bulk-based evidence 
bins (defined by the `bin.method` argument), as well as different methods to 
use this grouping for multiple testing correction `correction.method`.

Here we call a 'hypothesis' a differential expression test on one gene in one
cell type. We define the 'contribution' of the cell type to the bulk 
expression of the gene as the proportion of the total pseudobulk reads for 
that gene that is contributed by the cell type (across all samples).

The following `bin.method` options are available (if `pb` is missing, only 
`sig` is available):
\itemize{
\item{**sig** : the bulk significance values are used as is, eventually 
  taking the direction of the logFC into account if provided in `bulkDEA`.
  `nbins` are created using quantiles.}
\item{**combined** : first, significance-based bins are created in the same
  fashion as in `bin.method="sig"`. Each significance bin is then further 
  split into genes for which the cell type contributes much to the bulk, and
  genes for which the cell type contributes little.}
\item{**PAS** (Proportion-Adjusted Significance): for each hypothesis, the 
 bulk significance is adjusted based on the cell type contribution to the 
 bulk of that gene using `inv.logit( logit(p) * sqrt(c) )` where `p` and `c` 
 are respectively the bulk p-value and the proportion of bulk reads 
 contributed by the cell type). We then split this covariate into quantile 
 bins as is done for the "sig" method. *This is the recommended method.*}
\item{**PALFC** (Proportion-Adjusted logFC): same as for PAS, except that the
 bulk logFC is used instead of the significance. Note that when using this
 option, it is important to use shrunk logFC estimates, as for instance
 produced by \code{\link[edgeR]{predFC}}.}
\item{**asNA** : for hypotheses for which the cell type contributes little 
 to the bulk profile, the covariate (i.e. bulk p-value) is set to NA, 
 resulting it in making up its own bin.}
}

In all cases, if `useSign=TRUE` (default) and `bulkDEA` contains logFC 
information, then whenever the direction of the change is different between 
bulk and pseudobulk datasets for a gene in a given cell type, we increase the
bulk p-value to 0.7 (if it was below) for that cell type.

Once the bins are created, the following `correction.method` options are 
available:

\itemize{
\item{**binwise** : the Benjamini-Hochberg (BH) procedure is applied 
 separately for each bin. Doing this can lead to an increase in false 
 positives if the number of bins is large, and to correct for this the 
 resulting adjusted p-values are multiplied by `pmin(1,nbins/rank(p)`. This
 results is proper FDR control even across a large number of bins, but the
 method is more conservative than others.}
\item{**IHW** : The Independent Hypothesis Weighing (IHW) method of 
 Ignatiadis et al. (2016) is applied. See \code{\link[IHW]{ihw}}.}
\item{**gBH.LSL** and **gBH.TST**: the Grouped BH method of Hu, Zhao and Zhou
 (2010) is applied. The method has two options to compute the groups' rate 
 of true null hypotheses, LSL and TST, which make the corresponding 
 `correction.method` options (see \code{\link{gBH}} for more detail).
 *We recommend using `gBH.LSL`*.}
}

Each method exists in two flavors: a local one, which is applied for each 
cell type separately, and a global one, which is applied once across all cell
types (see the `local` argument). We recommend using the local one.
}
\references{
Germain, P.-L. and Robinson, M.D. (2025 preprint). Bulk-based hypothesis 
  weighing to increase power in single-cell diﬀerential expression analysis.
  bioRxiv, doi:10.1101/2025.04.15.648932
Hu, J. X. and Zhao, H. and Zhou, H. H. (2010). False Discovery Rate 
  Control With Groups. J Am Stat Assoc, 105(491):1215-1227.
Ignatiadis, N., Klaus, B., Zaugg, J. et al. (2016) Data-driven hypothesis 
weighting increases detection power in genome-scale multiple testing. Nat 
Methods 13, 577–580.
}
\author{
Pierre-Luc Germain
}
