% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mzIDpsm.R, R/mzIDpeptides.R, R/mzID.R, R/mzIDCollection.R
\docType{methods}
\name{flatten}
\alias{flatten}
\alias{flatten,mzID-method}
\alias{flatten,mzIDCollection-method}
\alias{flatten,mzIDpeptides-method}
\alias{flatten,mzIDpsm-method}
\title{Flatten an mzID related class into a table}
\usage{
flatten(object, safeNames = TRUE)

\S4method{flatten}{mzIDpsm}(object, safeNames = TRUE)

\S4method{flatten}{mzIDpeptides}(object, safeNames = TRUE)

\S4method{flatten}{mzID}(object, safeNames = TRUE)

\S4method{flatten}{mzIDCollection}(object, safeNames = TRUE)
}
\arguments{
\item{object}{The object to be flattened}

\item{safeNames}{Logical. Should column names be lowered to ensure 
compitability between different versions of the mzIdentML schema. 
Defaults to TRUE}
}
\value{
A \code{data.frame} with the flattened result or a list of 
data.frames
}
\description{
This function flattens the content of the object into a table by merging the 
content intelligently (it knows the links between the different objects).
}
\section{Methods (by class)}{
\itemize{
\item \code{mzIDpsm}: Merge id and scans according to the mapping

\item \code{mzIDpeptides}: Merge peptides with their modifications

\item \code{mzID}: Flatten an mzID object with respect to psm'

\item \code{mzIDCollection}: Flatten all mzID object in the collection into a list of
data frames.
}}
\examples{
exampleFile <- system.file('extdata', '55merge_tandem.mzid', package = 'mzID')
mzResults <- mzID(exampleFile)
head(flatten(mzResults))

}
\seealso{
\code{\link{mzID-class}} \code{\link{mzIDCollection-class}} 
\code{\link{mzIDpsm}} \code{\link{mzIDpeptides}}
}

