% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{rtncGTW,ncGTWwarp-method}
\alias{rtncGTW,ncGTWwarp-method}
\alias{rtncGTW}
\alias{ncGTWpeaks,ncGTWwarp-method}
\alias{ncGTWpeaks}
\title{ncGTWwarp-accessors}
\usage{
\S4method{rtncGTW}{ncGTWwarp}(object)

\S4method{ncGTWpeaks}{ncGTWwarp}(object)
}
\arguments{
\item{object}{a \code{\link{ncGTWwarp}} object.}
}
\value{
\code{rtncGTW} returns a list of the same length as the sample
number, in which each element is a vector of the realigned RT of the
corresponding sample.

\code{rtncGTW} returns a matrix containing peak data with adjusted
RT.
}
\description{
Accessors to the realigned RT and the peaks with adjusted RT of ncGTW
alignment.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]
\dontrun{
# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

# initialize the parameters of ncGTW alignment with default
ncGTWparam <- initncGTWparam()

# run ncGTW alignment
ncGTWoutputs <- vector('list', length(ncGTWinputs))
ncGTWoutputs[[1]] <- ncGTWalign(ncGTWinputs[[1]], xcmsLargeWin, 5,
        ncGTWparam = ncGTWparam)

# adjust RT with the realignment results from ncGTW
ncGTWres <- xcmsLargeWin
adjustRes <- adjustRT(ncGTWres, ncGTWinputs[[1]], ncGTWoutputs[[1]], ppm)
rt <- rtncGTW(adjustRes)
peaks <- ncGTWpeaks(adjustRes)
}
}
