% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_create_group}
\alias{ndex_create_group}
\title{Create Group}
\usage{
ndex_create_group(ndexcon, groupName, image, website, description, properties)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupName}{character; name of the new graoup}

\item{image}{character (optional); URL of the account owner's image}

\item{website}{character (optional); URL of the account owner's web site}

\item{description}{character (optional); Short description of this user}

\item{properties}{list (optional); additional properties for the group}
}
\value{
url (including the UUID) of the newly created group
}
\description{
Create a group owned by the authenticated user based on the supplied group JSON object.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

POST: ndex_config$api$group$create
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
# groupURL = ndex_create_group(ndexcon, 'SomeGroupName')
## [1] "http://public.ndexbio.org/v2/group/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"
# groupURL = ndex_create_group(ndexcon, 'SomeGroupName', 
#                              image='http://bit.ly/1M3NoQZ', 
#                              website='www.gidf.com', 
#                              description='A very special group..')
NULL
}
