% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_create_user}
\alias{ndex_create_user}
\title{Create a user}
\usage{
ndex_create_user(
  ndexcon,
  userName,
  password,
  emailAddress,
  isIndividual = TRUE,
  displayName,
  firstName,
  lastName,
  image,
  website,
  description,
  verbose = FALSE
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userName}{character; name of the new user}

\item{password}{character; password for the new user}

\item{emailAddress}{character (optional); email address (used for verification if enabled)}

\item{isIndividual}{boolean (default: TRUE); True if this account is for an individual user. False means this account is for an organization or a project etc.}

\item{displayName}{character (optional); Display name of this account, only applied to non-individual accounts.}

\item{firstName}{character (optional); Account owner's first name, only applies to individual accounts.}

\item{lastName}{character (optional); Account owner's last name, only appliies to individual accounts.}

\item{image}{character (optional); URL of the account owner's image.}

\item{website}{character (optional); URL of the account owner's web site}

\item{description}{character (optional); Short description of this user.}

\item{verbose}{logical (optional); whether to print out extended feedback}
}
\value{
UUID of the newly created user if email verification is turned off, else an empty string ("")
}
\description{
Create a new user based on a JSON object specifying username, password, and emailAddress. 
Username and emailAddress must be unique in the database.
If email verification is turned on on the server, this call returns code 220 (Accepted), the location field in the header has the URL to check the status of the newly created user account.
If email verification is turned on off on the server, this function returns 201 (Created). The URL for getting the newly created user is in the response body and the Location header.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$create
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Create a new user
# userId = ndex_create_user(ndexcon, 'SomeUserName', 'SecretPassword', 'SomeUserName@ndex.org')
## [1] "uuuuuuuu-ssss-eeee-rrrr-123456789abc"
# userId = ndex_create_user(ndexcon, 'ASpecialProject', 'SecretPassword', 
#                           'ASpecialProject@ndex.org', isIndividual=TRUE,
#                           displayName='Area51', firstName='John', lastName='Doe', 
#                           website='www.gidf.com', description='Nothing to see here..')
NULL
}
