% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_simple_operations.r
\name{ndex_delete_network}
\alias{ndex_delete_network}
\title{Delete a network}
\usage{
ndex_delete_network(ndexcon, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}
}
\value{
NULL on success; Error else
}
\description{
Delete a network
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

DELETE: ndex_config$api$network$delete
}

\examples{
## Establish a server connections with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find a network and get its UUID
# networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
# networkId = networks[1,"externalId"] 
## Delete the network
# ndex_delete_network(ndexcon, networkId)
NULL
}
