% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_group_set_membership}
\alias{ndex_group_set_membership}
\title{Add or Update a Group Member}
\usage{
ndex_group_set_membership(ndexcon, groupId, userId, type = "MEMBER")
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}

\item{userId}{character; unique ID (UUID) of the user}

\item{type}{character (optional)("GROUPADMIN"|"MEMBER")(default: "MEMBER"); Type of group membership}
}
\value{
Empty string ("") on success, else error
}
\description{
Updates the membership corresponding to the GroupMembership type specified in the URL parameter.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

PUT: ndex_config$api$user$membership$update
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get own id
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find own groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
# groupId = groups[1,"externalId"]
## Find an other user and get the id
# user = ndex_find_user_byName(ndexcon, 'SomeOtherAccountName')
# userId = user$externalId
## Add other user to the group
# ndex_group_set_membership(ndexcon, groupId, userId)
## Update other user's group permission
# ndex_group_set_membership(ndexcon, groupId, userId, type='MEMBER')    ## same as before
## Make other user to group admin (lose own admin permission)
# ndex_group_set_membership(ndexcon, groupId, userId, type='GROUPADMIN')
NULL
}
