% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanBEDtoBG.R
\name{CleanBEDtoBG}
\alias{CleanBEDtoBG}
\title{CleanBEDtoBG}
\usage{
CleanBEDtoBG(
  in_bed,
  out_bedGraph = NA,
  unwanted_chromosomes = NULL,
  alignment = "hg19"
)
}
\arguments{
\item{in_bed}{Name of sorted BAM file to be converted to a bedGraph file.
Required.}

\item{out_bedGraph}{Name of bedGraph output file, including full directory
path; a string. Default in_bam prefix.}

\item{unwanted_chromosomes}{A vector of unwanted chromosomes that are present
in the BAM file.}

\item{alignment}{The human genome alignment used, either "hg19" or "hg38".
Default "hg19"}
}
\value{
deposits bedGraph from BED in same directory
}
\description{
Writes a script to convert a BED file to a clean bedGraph file.
}
\examples{
bam <- system.file("extdata/chr4and5.bam", package="nearBynding")
out_bed <- "bamto.bed"
## convert BAM to BED
if(suppressWarnings(system2("bedtools", "--version",
stdout = NULL, stderr = NULL)) == 0){
    system2("bedtools", paste0("bamtobed -i ", bam, " > ", out_bed))
}
CleanBEDtoBG(in_bed = out_bed,
    alignment = "hg38")


}
