% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_config.R
\name{write_config}
\alias{write_config}
\title{write_config}
\usage{
write_config(
  name_config = "config.cfg",
  chrom_size,
  Rscript = FALSE,
  silent = TRUE,
  na_noise = FALSE,
  bin = 1,
  threshold = 0,
  cross_width = 200,
  wSize = 10000,
  kernel_width = 1000,
  resPath = "."
)
}
\arguments{
\item{name_config}{Name of output config file. Default config.cfg}

\item{chrom_size}{Name of chromosome size file. File must be in two-column
format without a header where first column is chromosome name and second
column is chromosome length, as from getChainChrSize. Required}

\item{Rscript}{Write R script for the result presentation. Equivalent to -r
argument in StereoGene. Default FALSE}

\item{silent}{Provides an output when Stereogene is run. Equivalent
to -s or -silent argument in StereoGene. Default TRUE}

\item{na_noise}{Use NA values as unknown and fill them with noise. Equivalent
to -NA argument in StereoGene. Default FALSE}

\item{bin}{Bin size for input averaging; an integer. Default 1}

\item{threshold}{Threshold for input data to remove small values. An integer
between 0 and 250. Default 0}

\item{cross_width}{Width of cross-correlation plot output in Rscript; an
integer. Default 200.}

\item{wSize}{Window size; an integer. If windows are too small, cross
correlations will have a lot of noise; if they are too large, there may be
too few windows for robust statistical assessment. Default 10000}

\item{kernel_width}{Kernel span in nucleotides; an integer. Equivalent to
KernelSigma invStereoGene. Default 1000}

\item{resPath}{Folder to store results. Default is current directory.}
}
\value{
writes a configuration file into directory
}
\description{
Writes a configuration file for use by Stereogenes in the
working directory.
}
\note{
Not all StereoGene parameters are included in this function so refer to
the StereoGene manual and modify the output .cfg file manually if additional
parameters are desired.
}
\examples{
## Write a config file named "test.cfg" with chromosome size file "test.size"
write_config(name_config = "test.cfg",
            chrom_size = "test.size")

}
