% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_weights_heatmap.R
\name{block_weights_heatmap}
\alias{block_weights_heatmap}
\title{block_weights_heatmap}
\usage{
block_weights_heatmap(mcia_results)
}
\arguments{
\item{mcia_results}{MCIA results object returned from `nipals_multiblock`}
}
\value{
heatmap object containing the block weights as a heatmap
}
\description{
Function to plot heatmap of block score weights
}
\details{
Plotting function for heatmap of block score weights
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                  plots = "none", tol = 1e-12)
block_weights_heatmap(mcia_results)
}
