% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nipals_multiblock.R
\name{nipals_multiblock}
\alias{nipals_multiblock}
\title{Main NIPALS computation loop}
\usage{
nipals_multiblock(
  data_blocks_mae,
  col_preproc_method = "colprofile",
  block_preproc_method = "unit_var",
  num_PCs = 10,
  tol = 1e-09,
  max_iter = 1000,
  color_col = NULL,
  deflationMethod = "block",
  plots = "all",
  harmonize = TRUE
)
}
\arguments{
\item{data_blocks_mae}{a MultiAssayExperiment class
object (with sample metadata as a dataframe in the colData attribute).}

\item{col_preproc_method}{an option for the desired column-level data
pre-processing, either:
\itemize{
\item `colprofile` applies column-centering, row and column weighting by
contribution to variance.
\item `standardized` centers each column and divides by its standard
deviation.
\item `centered_only` ONLY centers data
}}

\item{block_preproc_method}{an option for the desired block-level data
pre-processing, either:\itemize{
\item `unit_var` FOR CENTERED MATRICES ONLY - divides each block by the
square root of its variance
\item `num_cols` divides each block by the number of variables in the block.
\item `largest_sv` divides each block by its largest singular value.
\item `none` performs no preprocessing
}}

\item{num_PCs}{the maximum order of scores/loadings}

\item{tol}{a number for the tolerance on the stopping criterion for NIPALS}

\item{max_iter}{a number for the maximum number of times NIPALS should
iterate}

\item{color_col}{Optional argument with the column name of the `metadata`
data frame used to define plotting colors}

\item{deflationMethod}{an option for the desired deflation method, either:
\itemize{
\item `block` deflation via block loadings (for MCIA, default)
\item `global` deflation via global scores (for CPCA)
}}

\item{plots}{an option to display various plots of results: \itemize{
\item `all` displays plots of block scores, global scores, and eigenvalue
scree plot
\item `global` displays only global score projections and eigenvalue scree
plot
\item `none` does not display plots
}}

\item{harmonize}{boolean whether or not samples should be checked for duplicates 
and re-ordered so that each row corresponds to the same sample across datasets.
Set to FALSE to greatly reduce computation time on many samples (default = TRUE).}
}
\value{
a `nipalsResult` object with the following fields: \itemize{
\item `global_scores` a matrix containing global scores as columns
(NOT normalized to unit variance)
\item `global_loadings` a matrix containing global loadings as columns
\item `global_score_weights` a matrix of weights to express global scores as
a combination of block scores. Has dimensions "num_Blocks" by "num_PCs"
\item `eigvals` a matrix containing the eigenvalue for each computed global
score.
\item `block scores` a list of matrices, each contains the scores for one
block
\item `block loadings` a list of matrices, each contains the loadings for
one block (w/ unit length)
\item `block score weights` a matrix containing weights for each block score
of each order used to construct the global scores.
\item `col_preproc_method` the column preprocessing method used on the data.
\item `block_variances` a list of variances of each block AFTER
NORMALIZATION OPTION APPLIED
\item `metadata` the metadata dataframe supplied with the `metadata`
argument. Note: overrides metadata present in any MAE class object.
}
}
\description{
Applies the full adjusted NIPALS algorithm to generate block
and global scores/loadings with the desired deflation method.
}
\details{
Follows the NIPALS algorithm as described by Hanafi et. al. (2010).
For each order of scores/loadings, the vectors are computed via the
`nipals_iter` function, then used to deflate the data matrix according to
the desired deflation method.
This process is repeated up to the desired maximum order of scores/loadings.
}
\examples{
   data(NCI60)
   data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                                 colData=metadata_NCI60)
   NIPALS_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                       tol = 1e-12, max_iter = 1000,
                                       col_preproc_method = "colprofile",
                                       deflationMethod = "block")
   MCIA_results <- nipals_multiblock(data_blocks_mae, num_PCs = 4)
   CPCA_results <- nipals_multiblock(data_blocks_mae, num_PCs = 4,
   deflationMethod = 'global')

}
