% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_mae.R
\name{simple_mae}
\alias{simple_mae}
\title{Create an MAE object from a list of data matrices and column data}
\usage{
simple_mae(matrix_list, row_format = "feature", colData_input = NULL)
}
\arguments{
\item{matrix_list}{named list of data matrices}

\item{row_format}{for lists of data frames, indicates whether rows of
datasets denote `feature` (default) or `sample`.}

\item{colData_input}{a data frame containing sample metadata; sample names
in the rownames should correspond to samples names in `matrix_list`}
}
\value{
List of harmonized data matrices for input into nipals_multiblock()
}
\description{
Create an MAE object from a set of data matrices and column data.
}
\details{
Requires that sample names match across experiments and are identical
to primary names, will only convert data matrices to SummarizedExperiment class.
If the data is more complex, please follow the guidelines
for creating an MAE object outlined in `help(MultiAssayExperiment)`
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks, row_format = "sample",
                              colData = metadata_NCI60)
}
