% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{save_batch_plots}
\alias{save_batch_plots}
\title{Save batch correction plots}
\usage{
save_batch_plots(
  orig,
  corrected,
  file,
  save = TRUE,
  width = 14,
  height = 10,
  batch = "Batch",
  color = "Batch",
  shape = "QC",
  color_scale = getOption("notame.color_scale_dis"),
  shape_scale = scale_shape_manual(values = c(15, 21)),
  assay.type1 = NULL,
  assay.type2 = NULL
)
}
\arguments{
\item{orig, corrected}{\code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
objects before and after batch effect correction}

\item{file}{path to the PDF file where the plots will be saved}

\item{save}{logical, if false, the plots are not saved but returned as a list}

\item{width, height}{width and height of the plots in inches}

\item{batch, color, shape}{column names of pheno data for batch labels,
and column used for coloring and shaping points (by default batch and QC)}

\item{color_scale, shape_scale}{scales for color and scale as returned by 
ggplot functions.}

\item{assay.type1}{character, assay of orig to be used in case of 
multiple assays.}

\item{assay.type2}{character, assay of corrected to be used in case of
multiple assays. If corrected is not supplied, this argument selects
another assay from orig.}
}
\value{
None, the function is invoked for its plot-saving side effect.
}
\description{
Saves plots of each feature showing the effect of batch correction.
Plots show QC samples and regular samples inside each batch, plus the
batch mean for biological samples and QC samples as a horizontal line.
The dashed line represents QC mean, the filled line represents biological
sample mean.
NOTE: if you change the shape variable, be sure to set a shape scale as well,
the default scale only has 2 values, so it can only accomodate 2 shapes.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")
# Batch correction
batch_corrected <- batchCorr::normalizeBatches(toy_notame_set, 
  assay.type = 1, batches = "Batch", sampleGroup = "Group", refGroup = "QC", 
  population = "all", name = "normalized")
# Plots of each feature
save_batch_plots(
  orig = toy_notame_set[1:10], corrected = batch_corrected[1:10],
  file = "batch_plots.pdf", assay.type2 = "normalized"
)
\dontshow{setwd(.old_wd)}
}
