% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merger.R
\name{merge_notame_sets}
\alias{merge_notame_sets}
\title{Merge SummarizedExperiment objects together}
\usage{
merge_notame_sets(..., merge = c("features", "samples"), assay.type = NULL)
}
\arguments{
\item{...}{\code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
objects or a list of objects}

\item{merge}{what to merge? features is used for combining analytical modes,
samples is used for batches}

\item{assay.type}{character, assay to be used in case of multiple assays. 
The same assay needs to be present in all objects to be merged, and the 
resultant object contains this single assay.}
}
\value{
A merged SummarizedExperiment object.
}
\description{
Merges two or more SummarizedExperiment objects together. Can be used to 
merge analytical modes or batches.
}
\details{
When merging samples, sample IDs that begin with "QC" or "Ref" are 
combined so that they have running numbers on them. This means that if both 
batches have samples called "QC_1", this will not result in an error,
but the sample IDs will be adjusted so that they are unique.
}
\examples{
# Merge analytical modes
data(hilic_neg_sample, hilic_pos_sample, rp_neg_sample, rp_pos_sample)
merged <- merge_notame_sets(
  hilic_neg_sample, hilic_pos_sample,
  rp_neg_sample, rp_pos_sample
)
# Merge batches
batch1 <- toy_notame_set[, toy_notame_set$Batch == 1]
batch2 <- toy_notame_set[, toy_notame_set$Batch == 2]
merged <- merge_notame_sets(batch1, batch2, merge = "samples")

}
