nucleoSim: Generate synthetic nucleosome maps
=====================
[![R-CMD-check-bioc](https://github.com/adeschen/nucleoSim/actions/workflows/check-bioc.yaml/badge.svg)](https://github.com/adeschen/nucleoSim/actions/workflows/check-bioc.yaml)
[![codecov](https://codecov.io/gh/ArnaudDroitLab/nucleoSim/branch/master/graph/badge.svg)](https://codecov.io/gh/ArnaudDroitLab/nucleoSim)
[![License: Artistic-2.0](https://img.shields.io/badge/License-Artistic%202.0-0298c3.svg)](https://opensource.org/licenses/Artistic-2.0)

This *nucleoSim* package generate synthetic nucleosome maps using
parameters given by users. Three different
distributions are available: Normal, Student and Uniform.

The package has been largely inspired by the
*Generating synthetic maps* section of the 
Bioconductor [nucleR](http://www.bioconductor.org/packages/release/bioc/html/nucleR.html) 
package (Flores and Orozco, 2011).


## Bioconductor Package ##

[![Bioconductor Time](http://bioconductor.org/shields/years-in-bioc/nucleoSim.svg)](http://bioconductor.org/packages/nucleoSim "Bioconductor status")

*nucleoSim* is now an official package of [Bioconductor](http://bioconductor.org/). 
The current release can be directly downloaded from their website:
[Current release](http://bioconductor.org/packages/nucleoSim)


## Citing ##

If you use this package for a publication, we would ask you to cite the following:

> Samb R, Khadraoui K, Belleau P, et al. (2015). "Using informative Multinomial-Dirichlet prior in a t-mixture with reversible jump estimation of nucleosome positions for genome-wide profiling." Statistical Applications in Genetics and Molecular Biology. Volume 14, Issue 6, Pages 517-532, ISSN (Online) 1544-6115, ISSN (Print) 2194-6302, December 2015, <a href="http://dx.doi.org/10.1515/sagmb-2014-0098">doi: 10.1515/sagmb-2014-0098</a>

> Flores O and Orozco M (2011). “nucleR: a package for non-parametric nucleosome positioning.” Bioinformatics, 27, pp. 2149–2150. <a href="http://dx.doi.org/10.1093/bioinformatics/btr345">doi: 10.1093/bioinformatics/btr345</a>

## Authors ##

[Rawane Samb](https://ca.linkedin.com/in/rawanesamb 
"Rawane Samb"), 
[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes 
"Astrid Desch&ecirc;nes"), 
[Pascal Belleau](http://ca.linkedin.com/in/pascalbelleau 
"Pascal Belleau") 
and [Arnaud Droit](http://ca.linkedin.com/in/drarnaud 
"Arnaud Droit").



## Maintainer ##

[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes 
"Astrid Desch&ecirc;nes")


## License ##

This package and the underlying *nucleoSim* code are distributed under the 
Artistic license 2.0. You are free to use and redistribute this software. 

For more information on Artistic 2.0 License see
[http://opensource.org/licenses/Artistic-2.0](http://opensource.org/licenses/Artistic-2.0)


## Bugs/Feature requests ##

If you have any bugs or feature requests,
[let us know](https://github.com/arnauddroitlab/nucleoSim/issues). Thanks!
