% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ompBAM.R
\name{use_ompBAM}
\alias{use_ompBAM}
\title{Sets up the package in the given directory to use ompBAM}
\usage{
use_ompBAM(path = ".")
}
\arguments{
\item{path}{The path to the desired directory in which to set up a new
R package. The directory name is assumed to be the package name.}
}
\value{
None
}
\description{
This function creates a new package in the given directory (unless one
already exists).
It then sets up the requisite dependencies and 'Make' and 'configure' files
so that the source code will successfully compile and link to the appropriate
external libraries (OpenMP, zlib) required for ompBAM. All 3 major platforms
(Linux, MacOS and Windows) are supported, although MacOS users must first
install the required OpenMP libraries first. See details below.
}
\details{
OpenMP is natively supported on Linux and Windows but
not on MacOS. To compile ompBAM_based
packages with OpenMP on MacOS, users should install the requisite OpenMP
libraries. An easy way to do this would be to run: \verb{brew install libomp}.
For details, refer to
\href{https://mac.r-project.org/openmp/}{this guide}
}
\examples{
path <- file.path(tempdir(), "myPkgName")
use_ompBAM(path)

}
