% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{read_templates_single}
\alias{read_templates_single}
\title{Input of a Single Template File.}
\usage{
read_templates_single(
  template.file,
  hdr.structure = NULL,
  delim = NULL,
  id.column = NULL,
  rm.keywords = NULL,
  remove.duplicates = FALSE,
  fw.region = c(1, 30),
  rev.region = c(1, 30),
  gap.character = "-",
  run = NULL
)
}
\arguments{
\item{template.file}{Path to a FASTA or CSV file containing the template sequences.}

\item{hdr.structure}{A character vector describing the information contained in the FASTA headers. In case that the headers of \code{fasta.file} contain
template group information, please include the keyword "GROUP" in
\code{hdr.structure}.}

\item{delim}{Delimiter for the information in the FASTA headers.}

\item{id.column}{Field in the header to be used as the identifier.}

\item{rm.keywords}{A vector of keywords that are used to remove templates whose headers contain any of the keywords.}

\item{remove.duplicates}{Whether duplicate sequence shall be removed.}

\item{fw.region}{The positional interval from the template 5' end specifying the 
binding sites for forward primers.}

\item{rev.region}{The positional interval from the template 3' end specifying
the binding sites for reverse primers.}

\item{gap.character}{The character in the input file representing gaps.
Gaps are automatically removed upon input.}

\item{run}{An identifier for the template sequences.}
}
\value{
An object of class \code{Templates}.
}
\description{
Read template sequences from a FASTA or CSV file.
}
\details{
When supplying a FASTA file with template sequences,
the input arguments \code{hdr.structure}, \code{delim}, \code{id.column}, 
\code{rm.keywords}, \code{remove.duplicates}, \code{fw.region}, 
\code{rev.region}, \code{gap.character}, and \code{run} are utilized.
Most importantly, \code{hdr.structure} and \code{delim} should
match the FASTA header structure.
When supplying a CSV file with template sequences,
the data are loaded without any modification and the CSV file
should represent an object of class \code{\link{Templates}}, which 
can be stored using the \code{\link{write_templates}} function.
}
\keyword{internal}
