% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costWasserMatchingEllipse.R
\name{costWasserMatchingEllipse}
\alias{costWasserMatchingEllipse}
\title{costWasserMatchinEllipse}
\usage{
costWasserMatchingEllipse(
  test.cytometry,
  training.cytometries,
  equal.weights = FALSE
)
}
\arguments{
\item{test.cytometry}{A clusetering represented as a list of clusters. Each cluster is a list with elements mean, cov, weight and type.}

\item{training.cytometries}{A list of clusterings with the same format as test.cytometry.}

\item{equal.weights}{If True, weights assigned to every cluster in a partion are uniform (1/number of clusters) when calculating the similarity distance. If False, weights assigned to clusters are the proportions of points in every cluster compared to the total amount of points in the partition.}
}
\value{
A vector representing the similarity distance between test.cytometry and the elements in training.cytometries.
}
\description{
Calculates a similarity distance based on the 2-Wassertein distance between mixtures of multivariate normal distributions.
}
\examples{
partition1 <- list(list(mean = c(1, 1), cov = diag(1, 2), weight = 0.5, type = '1'),
                  list(mean = c(-1, -1), cov = diag(1, 2), weight = 0.5, type = '2'))
partition2 <- list(list(list(mean = c(1, -1), cov = diag(1, 2),
                            weight = 0.5, type = '1'), list(mean = c(-1, 1), cov = diag(1, 2), weight = 0.5, type = '2')))
costWasserMatchingEllipse(partition1, partition2)

}
\references{
E del Barrio, H Inouzhe, JM Loubes, C Matran and A Mayo-Iscar. (2019) optimalFlow: Optimal-transport approach to flow cytometry gating and population matching. arXiv:1907.08006
}
