% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-ellipse.R
\name{plotEllipse}
\alias{plotEllipse}
\title{A function to plot probabiltiy ellipses on marker PCA plots to
visualise and assess TAGM models.}
\usage{
plotEllipse(object, params, dims = c(1, 2), method = "MAP", ...)
}
\arguments{
\item{object}{An [`MSnbase::MSnset`] containing quantitative
spatial proteomics data.}

\item{params}{An [`MAPParams`] with the TAGM-MAP parameters, as
generated by `tagmMapTrain`.}

\item{dims}{A `numeric(2)` with the principal components along
which to project the data. Default is `c(1, 2)`.}

\item{method}{The method used. Currently `"MAP"` only.}

\item{...}{Additional parameters passed to [plot2D()].}
}
\value{
A PCA plot of the marker data with probability
    ellipises. The outer ellipse contains 99% of the total
    probability whilst the middle and inner ellipses contain 95%
    and 90% of the probability respectively. The centres of the
    clusters are represented by black circumpunct (circled dot).
}
\description{
Note that when running PCA, this function does not scale the data
(centring is performed), as opposed to [plot2D()]. Only marker
proteins are displayed; the protein of unknown location, that are
not used to estimate the MAP parameters, are filtered out.
}
\seealso{
[plot2D()] to visualise spatial proteomics data using
    various dimensionality reduction methods. For details about
    TAGM models, see [tagmPredict()] and the *pRoloc-bayesian*
    vignette.
}
