% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{testMarkers}
\alias{testMarkers}
\title{Tests marker class sizes}
\usage{
testMarkers(object, xval = 5, n = 2, fcol = "markers", error = FALSE)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{xval}{The number cross-validation partitions. See the
\code{xval} argument in the parameter optimisation function(s).
Default is 5.}

\item{n}{Number of additional examples.}

\item{fcol}{The name of the prediction column in the
\code{featureData} slot. Default is \code{"markers"}.}

\item{error}{A \code{logical} specifying if an error should be
thown, instead of a warning.}
}
\value{
If successfull, the test invisibly returns \code{NULL}. Else,
it invisibly returns the names of the classes that have too few examples.
}
\description{
Tests if the marker class sizes are large enough for the parameter
optimisation scheme, i.e. the size is greater that \code{xval + n},
where the default \code{xval} is 5 and \code{n} is 2. If the test
is unsuccessful, a warning is thrown.
}
\details{
In case the test indicates that a class contains too few examples,
it is advised to either add some or, if not possible, to remove
the class altogether (see \code{\link{minMarkers}})
as the parameter optimisation is likely to fail or, at least,
produce unreliable results for that class.
}
\examples{
library("pRolocdata")
data(dunkley2006)
getMarkers(dunkley2006)
testMarkers(dunkley2006)
toosmall <- testMarkers(dunkley2006, xval = 15)
toosmall
try(testMarkers(dunkley2006, xval = 15, error = TRUE))
}
\seealso{
\code{\link{getMarkers}} and \code{\link{minMarkers}}
}
\author{
Laurent Gatto
}
