% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blastAnalysis.R
\name{blastAnalysis}
\alias{blastAnalysis}
\title{BLAST Analysis of PackTYPE Elements}
\usage{
blastAnalysis(
  packMatches,
  Genome,
  blastPath,
  protDb = NULL,
  autoDb = NULL,
  minE = 0.001,
  blastTask = "blastn-short",
  maxHits = 100,
  threads = 1,
  saveFolder = NULL,
  tirCutoff = 0
)
}
\arguments{
\item{packMatches}{A dataframe of potential Pack-TYPE transposable elements, 
in the format given by \code{\link{packSearch}}. This 
dataframe is in the format produced by coercing a 
\code{link[GenomicRanges:GRanges-class]{GRanges}} 
object to a dataframe: \code{data.frame(GRanges)}. 
Will be saved as a FASTA file for VSEARCH.}

\item{Genome}{A DNAStringSet object containing sequences referred to 
in \code{packMatches} (the object originally used to 
predict the transposons \code{\link{packSearch}}).}

\item{blastPath}{Path to the BLAST+ executable, or name of 
the BLAST+ application for Linux/MacOS users.}

\item{protDb}{For assigning Pack-TYPE elements. 
Path to the blast database containing nucleotide or protein
sequences to be matched against internal transposon 
sequences. Can be generated 
using BLAST+, or with 
\code{link{makeBlastDb}}.}

\item{autoDb}{For assigning autonomous elements. 
Path to the blast database containing nucleotide or protein
sequences to be matched against internal transposon 
sequences. Can be generated 
using BLAST+, or with 
\code{link{makeBlastDb}}.}

\item{minE}{Blast results with e values greater than
the specified cutoff will be ignored.}

\item{blastTask}{Type of BLAST+ task, defaults to "blastn-short".}

\item{maxHits}{Maximum hits returned by BLAST+ per query.}

\item{threads}{Allowable number of threads to be utilised by BLAST+.}

\item{saveFolder}{Directory to save BLAST+ results in; defaults 
to the working directory.}

\item{tirCutoff}{How many bases to ignore at the terminal ends of the 
transposons to prevent hits to TIR sequences.}
}
\value{
No return value; executes BLAST+ to generate hits 
which are stored in a .blast file in the chosen 
directory.
}
\description{
Run BLAST against user-specified databases of 
non-transposon and transposon-related proteins.
Can be used to classify transposons based on 
their internal sequences.
}
\examples{
\dontrun{
packMatches <- data(packMatches)
Genome <- data(arabidopsisThalianaRefseq)

blastAnalysis(packMatches, Genome, 
    protDb = "C:/data/TAIR10_CDS", 
    autoDb = "C:/data/TAIR10_transposons", 
    blastPath = "C:/blast/bin/blastn.exe")
}

}
\references{
For further information, see the NCBI BLAST+ application
documentation and help pages 
(https://www.ncbi.nlm.nih.gov/pubmed/20003500?dopt=Citation).
}
\seealso{
\code{\link{blastAnnotate}},
\code{\link{readBlast}}, \code{\link{packBlast}}
}
\author{
Jack Gisby
}
