% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPanelcnMops.R
\name{runPanelcnMops}
\alias{runPanelcnMops}
\title{Full copy number detection for targeted NGS panel data for 
multiple samples}
\usage{
runPanelcnMops(XandCB, testiv = c(1), countWindows, selectedGenes = NULL,
  I = c(0.025, 0.57, 1, 1.46, 2), normType = "quant",
  sizeFactor = "quant", qu = 0.25, quSizeFactor = 0.75, norm = 1,
  priorImpact = 1, minMedianRC = 30, maxControls = 25,
  corrThresh = 0.99, sex = "mixed")
}
\arguments{
\item{XandCB}{GRanges object of combined  read counts of test samples and
control samples as returned by countBamListInGRanges}

\item{testiv}{vector of indices of test samples in XandCB. Default = c(1)}

\item{countWindows}{data.frame with contents of a BED file as returned by
getWindows}

\item{selectedGenes}{vector of names of genes of interest or NULL if all 
genes are of interest. Default = NULL}

\item{I}{vector of positive real values containing the expected fold change
of the copy number classes. Length of this vector must be equal to the
length of the "classes" parameter vector. For targeted NGS panel data
the default is c(0.025,0.57,1,1.46,2)}

\item{normType}{type of the normalization technique. Each samples'
read counts are scaled such that the total number of reads are comparable
across samples. Options are "mean","median","poisson", "quant", and "mode"
Default = "quant"}

\item{sizeFactor}{parameter for calculating the size factors for
normalization. Options are "mean","median", "quant", and "mode".
Default = "quant"}

\item{qu}{Quantile of the normType if normType is set to "quant".
Real value between 0 and 1. Default = 0.25}

\item{quSizeFactor}{Quantile of the sizeFactor if sizeFactor is set to
"quant". 0.75 corresponds to "upper quartile normalization".
Real value between 0 and 1. Default = 0.75}

\item{norm}{the normalization strategy to be used. If set to 0 the read
counts are not normalized and cn.mops does not model different coverages.
If set to 1 the read counts are normalized. If set to 2 the read counts are
not normalized and cn.mops models different coverages. Default = 1.}

\item{priorImpact}{positive real value that reflects how strong the prior
assumption affects the result. The higher the value the more samples will be
assumed to have copy number 2. Default = 1}

\item{minMedianRC}{segments with median read counts over
all samples < minMedianRC are excluded from the analysis}

\item{maxControls}{integer reflecting the maximal numbers of controls to 
use. If set to 0 all highly correlated controls are used. Default = 25}

\item{corrThresh}{threshold for selecting highly correlated controls. 
Default = 0.99}

\item{sex}{either "mixed", "male", or "female" reflecting the sex of
all samples (test and control)}
}
\value{
list of instances of "CNVDetectionResult"
}
\description{
This function performs first quality control and runs 
panelcn.mops for CNV detection on all test samples.
}
\examples{
data(panelcn.mops)
XandCB <- test
elementMetadata(XandCB) <- cbind(elementMetadata(XandCB), 
                                    elementMetadata(control))
resultlist <- runPanelcnMops(XandCB, countWindows = countWindows)
}
