% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createClass_OmicsReg.R
\docType{class}
\name{OmicsReg-class}
\alias{OmicsReg-class}
\title{An S4 class for continuous responses within an \code{OmicsPathway} object}
\description{
This creates the \code{OmicsReg} class which extends the
  \code{OmicsPathway} master class.
}
\section{Slots}{

\describe{
\item{\code{assayData_df}}{An \eqn{N \times p} data frame with named columns.}

\item{\code{pathwayCollection}}{A list of known gene pathways with three or four
   elements:
\itemize{
  \item{\code{pathways} : }{A named list of character vectors. Each vector
     contains the names of the individual genes within that pathway as a
     vector of character strings. The names contained in these vectors must
     have non-empty overlap with the \emph{column names} of the
     \code{assayData_df} data frame. The names of the pathways (the list
     elements themselves) should be the a shorthand representation of the
     full pathway name.}
  \item{\code{TERMS} : }{A character vector the same length as the
    \code{pathways} list with the proper names of the pathways.}
  \item{\code{description} : }{An optional character vector the same length
     as the \code{pathways} list with additional information about the
     pathways.}
  \item{\code{setsize} : }{A named integer vector the same length as the
    \code{pathways} list with the number of genes in each pathway. This list
    item is calculated during the creation step of a \code{CreateOmics}
    function call.}
}}

\item{\code{response}}{A \code{numeric} vector of length \eqn{N}: the dependent
variable in a regression exercise.}
}}

\seealso{
\code{\link[=OmicsPathway-class]{OmicsPathway}},
  \code{\link{CreateOmics}}
}
