% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_OmicsSurv.R
\name{SubsetOmicsSurv}
\alias{SubsetOmicsSurv}
\alias{getEventTime}
\alias{getEventTime<-}
\alias{getEvent}
\alias{getEvent<-}
\alias{getEventTime,OmicsSurv-method}
\alias{getEventTime<-,OmicsSurv-method}
\alias{getEvent,OmicsSurv-method}
\alias{getEvent<-,OmicsSurv-method}
\title{Access and Edit Event Time or Indicator in an \code{OmicsSurv} Object}
\usage{
getEventTime(object, ...)

getEventTime(object) <- value

getEvent(object, ...)

getEvent(object) <- value

\S4method{getEventTime}{OmicsSurv}(object, ...)

\S4method{getEventTime}{OmicsSurv}(object) <- value

\S4method{getEvent}{OmicsSurv}(object, ...)

\S4method{getEvent}{OmicsSurv}(object) <- value
}
\arguments{
\item{object}{An object of class \code{\link{OmicsSurv-class}}.}

\item{...}{Dots for additional internal arguments (currently unused).}

\item{value}{The replacement object to be assigned to the specified slot.}
}
\value{
The "get" functions return the objects in the slots specified:
   \code{getEventTime} returns the \code{eventTime_num} vector object and
   \code{getEvent} returns the \code{eventObserved_lgl} vector object. These
   functions can extract these values from any valid \code{OmicsSurv} object.

   The "set" functions enable the user to edit or replace objects in the
   \code{eventTime_num} or \code{eventObserved_lgl} slots for any
   \code{OmicsSurv} object, provided that the new values do not violate the
   validity check of an \code{OmicsSurv} object. See "Details" for more
   information.
}
\description{
"Get" or "Set" the values of the \code{eventTime_num} or
   \code{eventObserved_lgl} slots of an object of class \code{OmicsSurv}.
}
\details{
These functions can be useful to set or extract the event time or
   death indicator from an \code{OmicsSurv} object. However, we recommend
   that users simply create a new, valid \code{OmicsSurv} object instead of
   modifying an existing one. The validity of edited objects is checked with
   the \code{\link{ValidOmicsSurv}} function.
}
\examples{
  data("colonSurv_df")
  data("colon_pathwayCollection")

  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "survival"
  )

  getEventTime(colon_Omics)
  getEvent(colon_Omics)

}
\seealso{
\code{\link{CreateOmics}}
}
