% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_permuteSamples.R
\name{RandomControlSample}
\alias{RandomControlSample}
\alias{SampleResponses}
\alias{SampleSurv}
\alias{SampleReg}
\alias{SampleCateg}
\title{Parametric bootstrap and non-parametric permutations of a response vector or
   matrix}
\usage{
SampleResponses(
  response_vec,
  event_vec = NULL,
  respType = c("survival", "regression", "categorical"),
  parametric = TRUE
)

SampleSurv(response_vec, event_vec, parametric = TRUE)

SampleReg(response_vec, parametric = TRUE)

SampleCateg(response_vec, parametric = TRUE)
}
\arguments{
\item{response_vec}{The dependent vector to sample from. For survival
response, this is the vector of event times. For regression or n-ary
classification, this is the vector of responses.}

\item{event_vec}{The death / event observation indicator vector for survival
response. This is coded as 0 for a right-censoring occurence and 1 for a
recorded event.}

\item{respType}{What type of response has been supplied. Options are
\code{"none"}, \code{"survival"}, \code{"regression"}, and
\code{"categorical"}. Defaults to \code{"none"} to match the default
\code{response = NULL} value.}

\item{parametric}{Should the random sample be taken using a parametric
bootstrap sample? Defaults to \code{TRUE}.}
}
\value{
If \code{parametric = FALSE}, a permutation of the supplied response
   is returned (for AES-PCA). If \code{parametric = TRUE}, we return a
   parametric bootstrap sample of the response.
}
\description{
Create a random parametric bootstrap sample or a permutation of
   the input response vector or matrix (for survival outcomes).
}
\details{
The distributions (for \code{parametric = TRUE}) are Weibull for
   survival times, Normal for regression response, and n-ary Multinomial for
   categorical response. Distributional parameters are estimated with their
   maximum likelihood estimates. When \code{parametric = FALSE}, the response
   vector or survival matrix is randomly ordered by row. This option should
   only be used when called from the AES-PCA method.
}
\examples{
  # DO NOT CALL THESE FUNCTIONS DIRECTLY.
  # Use AESPCA_pVals() or SuperPCA_pVals() instead

\dontrun{
  data("colon_pathwayCollection")
  data("colonSurv_df")

  SampleResponses(
    response_vec = colonSurv_df$OS_time,
    event_vec = colonSurv_df$OS_event,
    respType = "survival"
  )
}

}
\keyword{internal}
